// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using Newtonsoft.Json.Converters;
    using System.Runtime;
    using System.Runtime.Serialization;

    /// <summary>
    /// Defines values for VerificationType.
    /// </summary>
    [JsonConverter(typeof(StringEnumConverter))]
    public enum VerificationType
    {
        /// <summary>
        /// The Image is guaranteed to be compatible with the associated
        /// Compute Node agent SKU and all Batch features have been confirmed
        /// to work as expected.
        /// </summary>
        [EnumMember(Value = "verified")]
        Verified,
        /// <summary>
        /// The associated Compute Node agent SKU should have binary
        /// compatibility with the Image, but specific functionality has not
        /// been verified.
        /// </summary>
        [EnumMember(Value = "unverified")]
        Unverified
    }
    internal static class VerificationTypeEnumExtension
    {
        internal static string ToSerializedValue(this VerificationType? value)
        {
            return value == null ? null : ((VerificationType)value).ToSerializedValue();
        }

        internal static string ToSerializedValue(this VerificationType value)
        {
            switch( value )
            {
                case VerificationType.Verified:
                    return "verified";
                case VerificationType.Unverified:
                    return "unverified";
            }
            return null;
        }

        internal static VerificationType? ParseVerificationType(this string value)
        {
            switch( value )
            {
                case "verified":
                    return VerificationType.Verified;
                case "unverified":
                    return VerificationType.Unverified;
            }
            return null;
        }
    }
}
