// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// Specifies the security profile settings for the managed disk. **Note**:
    /// It can only be set for Confidential VMs and required when using
    /// Confidential VMs.
    /// </summary>
    public partial class VMDiskSecurityProfile
    {
        /// <summary>
        /// Initializes a new instance of the VMDiskSecurityProfile class.
        /// </summary>
        public VMDiskSecurityProfile()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the VMDiskSecurityProfile class.
        /// </summary>
        /// <param name="securityEncryptionType">Specifies the EncryptionType
        /// of the managed disk. It is set to VMGuestStateOnly for encryption
        /// of just the VMGuestState blob, and NonPersistedTPM for not
        /// persisting firmware state in the VMGuestState blob. **Note**: It
        /// can be set for only Confidential VMs and is required when using
        /// Confidential VMs.</param>
        public VMDiskSecurityProfile(string securityEncryptionType = default(string))
        {
            SecurityEncryptionType = securityEncryptionType;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets specifies the EncryptionType of the managed disk. It
        /// is set to VMGuestStateOnly for encryption of just the VMGuestState
        /// blob, and NonPersistedTPM for not persisting firmware state in the
        /// VMGuestState blob. **Note**: It can be set for only Confidential
        /// VMs and is required when using Confidential VMs.
        /// </summary>
        /// <remarks>
        /// Possible values include: 'NonPersistedTPM', 'VMGuestStateOnly'
        /// </remarks>
        [JsonProperty(PropertyName = "securityEncryptionType")]
        public string SecurityEncryptionType { get; set; }

    }
}
