// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// Properties used to create a user used to execute Tasks on an Azure
    /// Batch Compute Node.
    /// </summary>
    public partial class UserAccount
    {
        /// <summary>
        /// Initializes a new instance of the UserAccount class.
        /// </summary>
        public UserAccount()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the UserAccount class.
        /// </summary>
        /// <param name="name">The name of the user Account. Names can contain
        /// any Unicode characters up to a maximum length of 20.</param>
        /// <param name="password">The password for the user Account.</param>
        /// <param name="elevationLevel">The elevation level of the user
        /// Account.</param>
        /// <param name="linuxUserConfiguration">The Linux-specific user
        /// configuration for the user Account.</param>
        /// <param name="windowsUserConfiguration">The Windows-specific user
        /// configuration for the user Account.</param>
        public UserAccount(string name, string password, ElevationLevel? elevationLevel = default(ElevationLevel?), LinuxUserConfiguration linuxUserConfiguration = default(LinuxUserConfiguration), WindowsUserConfiguration windowsUserConfiguration = default(WindowsUserConfiguration))
        {
            Name = name;
            Password = password;
            ElevationLevel = elevationLevel;
            LinuxUserConfiguration = linuxUserConfiguration;
            WindowsUserConfiguration = windowsUserConfiguration;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the name of the user Account. Names can contain any
        /// Unicode characters up to a maximum length of 20.
        /// </summary>
        [JsonProperty(PropertyName = "name")]
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the password for the user Account.
        /// </summary>
        [JsonProperty(PropertyName = "password")]
        public string Password { get; set; }

        /// <summary>
        /// Gets or sets the elevation level of the user Account.
        /// </summary>
        /// <remarks>
        /// The default value is nonAdmin. Possible values include: 'nonAdmin',
        /// 'admin'
        /// </remarks>
        [JsonProperty(PropertyName = "elevationLevel")]
        public ElevationLevel? ElevationLevel { get; set; }

        /// <summary>
        /// Gets or sets the Linux-specific user configuration for the user
        /// Account.
        /// </summary>
        /// <remarks>
        /// This property is ignored if specified on a Windows Pool. If not
        /// specified, the user is created with the default options.
        /// </remarks>
        [JsonProperty(PropertyName = "linuxUserConfiguration")]
        public LinuxUserConfiguration LinuxUserConfiguration { get; set; }

        /// <summary>
        /// Gets or sets the Windows-specific user configuration for the user
        /// Account.
        /// </summary>
        /// <remarks>
        /// This property can only be specified if the user is on a Windows
        /// Pool. If not specified and on a Windows Pool, the user is created
        /// with the default options.
        /// </remarks>
        [JsonProperty(PropertyName = "windowsUserConfiguration")]
        public WindowsUserConfiguration WindowsUserConfiguration { get; set; }

    }
}
