// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// The result of uploading Batch service log files from a specific Compute
    /// Node.
    /// </summary>
    public partial class UploadBatchServiceLogsResult
    {
        /// <summary>
        /// Initializes a new instance of the UploadBatchServiceLogsResult
        /// class.
        /// </summary>
        public UploadBatchServiceLogsResult()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the UploadBatchServiceLogsResult
        /// class.
        /// </summary>
        /// <param name="virtualDirectoryName">The virtual directory within
        /// Azure Blob Storage container to which the Batch Service log file(s)
        /// will be uploaded.</param>
        /// <param name="numberOfFilesUploaded">The number of log files which
        /// will be uploaded.</param>
        public UploadBatchServiceLogsResult(string virtualDirectoryName, int numberOfFilesUploaded)
        {
            VirtualDirectoryName = virtualDirectoryName;
            NumberOfFilesUploaded = numberOfFilesUploaded;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the virtual directory within Azure Blob Storage
        /// container to which the Batch Service log file(s) will be uploaded.
        /// </summary>
        /// <remarks>
        /// The virtual directory name is part of the blob name for each log
        /// file uploaded, and it is built based poolId, nodeId and a unique
        /// identifier.
        /// </remarks>
        [JsonProperty(PropertyName = "virtualDirectoryName")]
        public string VirtualDirectoryName { get; set; }

        /// <summary>
        /// Gets or sets the number of log files which will be uploaded.
        /// </summary>
        [JsonProperty(PropertyName = "numberOfFilesUploaded")]
        public int NumberOfFilesUploaded { get; set; }

    }
}
