// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// The Azure Batch service log files upload configuration for a Compute
    /// Node.
    /// </summary>
    public partial class UploadBatchServiceLogsConfiguration
    {
        /// <summary>
        /// Initializes a new instance of the
        /// UploadBatchServiceLogsConfiguration class.
        /// </summary>
        public UploadBatchServiceLogsConfiguration()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the
        /// UploadBatchServiceLogsConfiguration class.
        /// </summary>
        /// <param name="containerUrl">The URL of the container within Azure
        /// Blob Storage to which to upload the Batch Service log
        /// file(s).</param>
        /// <param name="startTime">The start of the time range from which to
        /// upload Batch Service log file(s).</param>
        /// <param name="endTime">The end of the time range from which to
        /// upload Batch Service log file(s).</param>
        /// <param name="identityReference">The reference to the user assigned
        /// identity to use to access Azure Blob Storage specified by
        /// containerUrl.</param>
        public UploadBatchServiceLogsConfiguration(string containerUrl, System.DateTime startTime, System.DateTime? endTime = default(System.DateTime?), ComputeNodeIdentityReference identityReference = default(ComputeNodeIdentityReference))
        {
            ContainerUrl = containerUrl;
            StartTime = startTime;
            EndTime = endTime;
            IdentityReference = identityReference;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the URL of the container within Azure Blob Storage to
        /// which to upload the Batch Service log file(s).
        /// </summary>
        /// <remarks>
        /// If a user assigned managed identity is not being used, the URL must
        /// include a Shared Access Signature (SAS) granting write permissions
        /// to the container. The SAS duration must allow enough time for the
        /// upload to finish. The start time for SAS is optional and
        /// recommended to not be specified.
        /// </remarks>
        [JsonProperty(PropertyName = "containerUrl")]
        public string ContainerUrl { get; set; }

        /// <summary>
        /// Gets or sets the start of the time range from which to upload Batch
        /// Service log file(s).
        /// </summary>
        /// <remarks>
        /// Any log file containing a log message in the time range will be
        /// uploaded. This means that the operation might retrieve more logs
        /// than have been requested since the entire log file is always
        /// uploaded, but the operation should not retrieve fewer logs than
        /// have been requested.
        /// </remarks>
        [JsonProperty(PropertyName = "startTime")]
        public System.DateTime StartTime { get; set; }

        /// <summary>
        /// Gets or sets the end of the time range from which to upload Batch
        /// Service log file(s).
        /// </summary>
        /// <remarks>
        /// Any log file containing a log message in the time range will be
        /// uploaded. This means that the operation might retrieve more logs
        /// than have been requested since the entire log file is always
        /// uploaded, but the operation should not retrieve fewer logs than
        /// have been requested. If omitted, the default is to upload all logs
        /// available after the startTime.
        /// </remarks>
        [JsonProperty(PropertyName = "endTime")]
        public System.DateTime? EndTime { get; set; }

        /// <summary>
        /// Gets or sets the reference to the user assigned identity to use to
        /// access Azure Blob Storage specified by containerUrl.
        /// </summary>
        /// <remarks>
        /// The identity must have write access to the Azure Blob Storage
        /// container.
        /// </remarks>
        [JsonProperty(PropertyName = "identityReference")]
        public ComputeNodeIdentityReference IdentityReference { get; set; }

    }
}
