// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using Newtonsoft.Json.Converters;
    using System.Runtime;
    using System.Runtime.Serialization;

    /// <summary>
    /// Defines values for UpgradeMode.
    /// </summary>
    [JsonConverter(typeof(StringEnumConverter))]
    public enum UpgradeMode
    {
        /// <summary>
        /// All virtual machines in the scale set are automatically updated at
        /// the same time.
        /// </summary>
        [EnumMember(Value = "automatic")]
        Automatic,
        /// <summary>
        /// You control the application of updates to virtual machines in the
        /// scale set. You do this by using the manualUpgrade action.
        /// </summary>
        [EnumMember(Value = "manual")]
        Manual,
        /// <summary>
        /// The existing instances in a scale set are brought down in batches
        /// to be upgraded. Once the upgraded batch is complete, the instances
        /// will begin taking traffic again and the next batch will begin. This
        /// continues until all instances brought up-to-date.
        /// </summary>
        [EnumMember(Value = "rolling")]
        Rolling
    }
    internal static class UpgradeModeEnumExtension
    {
        internal static string ToSerializedValue(this UpgradeMode? value)
        {
            return value == null ? null : ((UpgradeMode)value).ToSerializedValue();
        }

        internal static string ToSerializedValue(this UpgradeMode value)
        {
            switch( value )
            {
                case UpgradeMode.Automatic:
                    return "automatic";
                case UpgradeMode.Manual:
                    return "manual";
                case UpgradeMode.Rolling:
                    return "rolling";
            }
            return null;
        }

        internal static UpgradeMode? ParseUpgradeMode(this string value)
        {
            switch( value )
            {
                case "automatic":
                    return UpgradeMode.Automatic;
                case "manual":
                    return UpgradeMode.Manual;
                case "rolling":
                    return UpgradeMode.Rolling;
            }
            return null;
        }
    }
}
