// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Information about a Task failure.
    /// </summary>
    public partial class TaskFailureInformation
    {
        /// <summary>
        /// Initializes a new instance of the TaskFailureInformation class.
        /// </summary>
        public TaskFailureInformation()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the TaskFailureInformation class.
        /// </summary>
        /// <param name="category">The category of the Task error.</param>
        /// <param name="code">An identifier for the Task error. Codes are
        /// invariant and are intended to be consumed programmatically.</param>
        /// <param name="message">A message describing the Task error, intended
        /// to be suitable for display in a user interface.</param>
        /// <param name="details">A list of additional details related to the
        /// error.</param>
        public TaskFailureInformation(ErrorCategory category, string code = default(string), string message = default(string), IList<NameValuePair> details = default(IList<NameValuePair>))
        {
            Category = category;
            Code = code;
            Message = message;
            Details = details;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the category of the Task error.
        /// </summary>
        /// <remarks>
        /// Possible values include: 'userError', 'serverError'
        /// </remarks>
        [JsonProperty(PropertyName = "category")]
        public ErrorCategory Category { get; set; }

        /// <summary>
        /// Gets or sets an identifier for the Task error. Codes are invariant
        /// and are intended to be consumed programmatically.
        /// </summary>
        [JsonProperty(PropertyName = "code")]
        public string Code { get; set; }

        /// <summary>
        /// Gets or sets a message describing the Task error, intended to be
        /// suitable for display in a user interface.
        /// </summary>
        [JsonProperty(PropertyName = "message")]
        public string Message { get; set; }

        /// <summary>
        /// Gets or sets a list of additional details related to the error.
        /// </summary>
        [JsonProperty(PropertyName = "details")]
        public IList<NameValuePair> Details { get; set; }

    }
}
