// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Specifies any dependencies of a Task. Any Task that is explicitly
    /// specified or within a dependency range must complete before the
    /// dependant Task will be scheduled.
    /// </summary>
    public partial class TaskDependencies
    {
        /// <summary>
        /// Initializes a new instance of the TaskDependencies class.
        /// </summary>
        public TaskDependencies()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the TaskDependencies class.
        /// </summary>
        /// <param name="taskIds">The list of Task IDs that this Task depends
        /// on. All Tasks in this list must complete successfully before the
        /// dependent Task can be scheduled.</param>
        /// <param name="taskIdRanges">The list of Task ID ranges that this
        /// Task depends on. All Tasks in all ranges must complete successfully
        /// before the dependent Task can be scheduled.</param>
        public TaskDependencies(IList<string> taskIds = default(IList<string>), IList<TaskIdRange> taskIdRanges = default(IList<TaskIdRange>))
        {
            TaskIds = taskIds;
            TaskIdRanges = taskIdRanges;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the list of Task IDs that this Task depends on. All
        /// Tasks in this list must complete successfully before the dependent
        /// Task can be scheduled.
        /// </summary>
        /// <remarks>
        /// The taskIds collection is limited to 64000 characters total (i.e.
        /// the combined length of all Task IDs). If the taskIds collection
        /// exceeds the maximum length, the Add Task request fails with error
        /// code TaskDependencyListTooLong. In this case consider using Task ID
        /// ranges instead.
        /// </remarks>
        [JsonProperty(PropertyName = "taskIds")]
        public IList<string> TaskIds { get; set; }

        /// <summary>
        /// Gets or sets the list of Task ID ranges that this Task depends on.
        /// All Tasks in all ranges must complete successfully before the
        /// dependent Task can be scheduled.
        /// </summary>
        [JsonProperty(PropertyName = "taskIdRanges")]
        public IList<TaskIdRange> TaskIdRanges { get; set; }

    }
}
