// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using Newtonsoft.Json.Converters;
    using System.Runtime;
    using System.Runtime.Serialization;

    /// <summary>
    /// Defines values for TaskAddStatus.
    /// </summary>
    [JsonConverter(typeof(StringEnumConverter))]
    public enum TaskAddStatus
    {
        /// <summary>
        /// The Task was added successfully.
        /// </summary>
        [EnumMember(Value = "success")]
        Success,
        /// <summary>
        /// The Task failed to add due to a client error and should not be
        /// retried without modifying the request as appropriate.
        /// </summary>
        [EnumMember(Value = "clienterror")]
        ClientError,
        /// <summary>
        /// Task failed to add due to a server error and can be retried without
        /// modification.
        /// </summary>
        [EnumMember(Value = "servererror")]
        ServerError
    }
    internal static class TaskAddStatusEnumExtension
    {
        internal static string ToSerializedValue(this TaskAddStatus? value)
        {
            return value == null ? null : ((TaskAddStatus)value).ToSerializedValue();
        }

        internal static string ToSerializedValue(this TaskAddStatus value)
        {
            switch( value )
            {
                case TaskAddStatus.Success:
                    return "success";
                case TaskAddStatus.ClientError:
                    return "clienterror";
                case TaskAddStatus.ServerError:
                    return "servererror";
            }
            return null;
        }

        internal static TaskAddStatus? ParseTaskAddStatus(this string value)
        {
            switch( value )
            {
                case "success":
                    return TaskAddStatus.Success;
                case "clienterror":
                    return TaskAddStatus.ClientError;
                case "servererror":
                    return TaskAddStatus.ServerError;
            }
            return null;
        }
    }
}
