// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// Result for a single Task added as part of an add Task collection
    /// operation.
    /// </summary>
    public partial class TaskAddResult
    {
        /// <summary>
        /// Initializes a new instance of the TaskAddResult class.
        /// </summary>
        public TaskAddResult()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the TaskAddResult class.
        /// </summary>
        /// <param name="status">The status of the add Task request.</param>
        /// <param name="taskId">The ID of the Task for which this is the
        /// result.</param>
        /// <param name="eTag">The ETag of the Task, if the Task was
        /// successfully added.</param>
        /// <param name="lastModified">The last modified time of the
        /// Task.</param>
        /// <param name="location">The URL of the Task, if the Task was
        /// successfully added.</param>
        /// <param name="error">The error encountered while attempting to add
        /// the Task.</param>
        public TaskAddResult(TaskAddStatus status, string taskId, string eTag = default(string), System.DateTime? lastModified = default(System.DateTime?), string location = default(string), BatchError error = default(BatchError))
        {
            Status = status;
            TaskId = taskId;
            ETag = eTag;
            LastModified = lastModified;
            Location = location;
            Error = error;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the status of the add Task request.
        /// </summary>
        /// <remarks>
        /// Possible values include: 'success', 'clientError', 'serverError'
        /// </remarks>
        [JsonProperty(PropertyName = "status")]
        public TaskAddStatus Status { get; set; }

        /// <summary>
        /// Gets or sets the ID of the Task for which this is the result.
        /// </summary>
        [JsonProperty(PropertyName = "taskId")]
        public string TaskId { get; set; }

        /// <summary>
        /// Gets or sets the ETag of the Task, if the Task was successfully
        /// added.
        /// </summary>
        /// <remarks>
        /// You can use this to detect whether the Task has changed between
        /// requests. In particular, you can be pass the ETag with an Update
        /// Task request to specify that your changes should take effect only
        /// if nobody else has modified the Job in the meantime.
        /// </remarks>
        [JsonProperty(PropertyName = "eTag")]
        public string ETag { get; set; }

        /// <summary>
        /// Gets or sets the last modified time of the Task.
        /// </summary>
        [JsonProperty(PropertyName = "lastModified")]
        public System.DateTime? LastModified { get; set; }

        /// <summary>
        /// Gets or sets the URL of the Task, if the Task was successfully
        /// added.
        /// </summary>
        [JsonProperty(PropertyName = "location")]
        public string Location { get; set; }

        /// <summary>
        /// Gets or sets the error encountered while attempting to add the
        /// Task.
        /// </summary>
        [JsonProperty(PropertyName = "error")]
        public BatchError Error { get; set; }

    }
}
