// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// An Azure Batch Task to add.
    /// </summary>
    /// <remarks>
    /// Batch will retry Tasks when a recovery operation is triggered on a
    /// Node. Examples of recovery operations include (but are not limited to)
    /// when an unhealthy Node is rebooted or a Compute Node disappeared due to
    /// host failure. Retries due to recovery operations are independent of and
    /// are not counted against the maxTaskRetryCount. Even if the
    /// maxTaskRetryCount is 0, an internal retry due to a recovery operation
    /// may occur. Because of this, all Tasks should be idempotent. This means
    /// Tasks need to tolerate being interrupted and restarted without causing
    /// any corruption or duplicate data. The best practice for long running
    /// Tasks is to use some form of checkpointing.
    /// </remarks>
    public partial class TaskAddParameter
    {
        /// <summary>
        /// Initializes a new instance of the TaskAddParameter class.
        /// </summary>
        public TaskAddParameter()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the TaskAddParameter class.
        /// </summary>
        /// <param name="id">A string that uniquely identifies the Task within
        /// the Job.</param>
        /// <param name="commandLine">The command line of the Task.</param>
        /// <param name="displayName">A display name for the Task.</param>
        /// <param name="containerSettings">The settings for the container
        /// under which the Task runs.</param>
        /// <param name="exitConditions">How the Batch service should respond
        /// when the Task completes.</param>
        /// <param name="resourceFiles">A list of files that the Batch service
        /// will download to the Compute Node before running the command
        /// line.</param>
        /// <param name="outputFiles">A list of files that the Batch service
        /// will upload from the Compute Node after running the command
        /// line.</param>
        /// <param name="environmentSettings">A list of environment variable
        /// settings for the Task.</param>
        /// <param name="affinityInfo">A locality hint that can be used by the
        /// Batch service to select a Compute Node on which to start the new
        /// Task.</param>
        /// <param name="constraints">The execution constraints that apply to
        /// this Task.</param>
        /// <param name="requiredSlots">The number of scheduling slots that the
        /// Task required to run.</param>
        /// <param name="userIdentity">The user identity under which the Task
        /// runs.</param>
        /// <param name="multiInstanceSettings">An object that indicates that
        /// the Task is a multi-instance Task, and contains information about
        /// how to run the multi-instance Task.</param>
        /// <param name="dependsOn">The Tasks that this Task depends
        /// on.</param>
        /// <param name="applicationPackageReferences">A list of Packages that
        /// the Batch service will deploy to the Compute Node before running
        /// the command line.</param>
        /// <param name="authenticationTokenSettings">The settings for an
        /// authentication token that the Task can use to perform Batch service
        /// operations.</param>
        public TaskAddParameter(string id, string commandLine, string displayName = default(string), TaskContainerSettings containerSettings = default(TaskContainerSettings), ExitConditions exitConditions = default(ExitConditions), IList<ResourceFile> resourceFiles = default(IList<ResourceFile>), IList<OutputFile> outputFiles = default(IList<OutputFile>), IList<EnvironmentSetting> environmentSettings = default(IList<EnvironmentSetting>), AffinityInformation affinityInfo = default(AffinityInformation), TaskConstraints constraints = default(TaskConstraints), int? requiredSlots = default(int?), UserIdentity userIdentity = default(UserIdentity), MultiInstanceSettings multiInstanceSettings = default(MultiInstanceSettings), TaskDependencies dependsOn = default(TaskDependencies), IList<ApplicationPackageReference> applicationPackageReferences = default(IList<ApplicationPackageReference>), AuthenticationTokenSettings authenticationTokenSettings = default(AuthenticationTokenSettings))
        {
            Id = id;
            DisplayName = displayName;
            CommandLine = commandLine;
            ContainerSettings = containerSettings;
            ExitConditions = exitConditions;
            ResourceFiles = resourceFiles;
            OutputFiles = outputFiles;
            EnvironmentSettings = environmentSettings;
            AffinityInfo = affinityInfo;
            Constraints = constraints;
            RequiredSlots = requiredSlots;
            UserIdentity = userIdentity;
            MultiInstanceSettings = multiInstanceSettings;
            DependsOn = dependsOn;
            ApplicationPackageReferences = applicationPackageReferences;
            AuthenticationTokenSettings = authenticationTokenSettings;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets a string that uniquely identifies the Task within the
        /// Job.
        /// </summary>
        /// <remarks>
        /// The ID can contain any combination of alphanumeric characters
        /// including hyphens and underscores, and cannot contain more than 64
        /// characters. The ID is case-preserving and case-insensitive (that
        /// is, you may not have two IDs within a Job that differ only by
        /// case).
        /// </remarks>
        [JsonProperty(PropertyName = "id")]
        public string Id { get; set; }

        /// <summary>
        /// Gets or sets a display name for the Task.
        /// </summary>
        /// <remarks>
        /// The display name need not be unique and can contain any Unicode
        /// characters up to a maximum length of 1024.
        /// </remarks>
        [JsonProperty(PropertyName = "displayName")]
        public string DisplayName { get; set; }

        /// <summary>
        /// Gets or sets the command line of the Task.
        /// </summary>
        /// <remarks>
        /// For multi-instance Tasks, the command line is executed as the
        /// primary Task, after the primary Task and all subtasks have finished
        /// executing the coordination command line. The command line does not
        /// run under a shell, and therefore cannot take advantage of shell
        /// features such as environment variable expansion. If you want to
        /// take advantage of such features, you should invoke the shell in the
        /// command line, for example using "cmd /c MyCommand" in Windows or
        /// "/bin/sh -c MyCommand" in Linux. If the command line refers to file
        /// paths, it should use a relative path (relative to the Task working
        /// directory), or use the Batch provided environment variable
        /// (https://docs.microsoft.com/azure/batch/batch-compute-node-environment-variables).
        /// </remarks>
        [JsonProperty(PropertyName = "commandLine")]
        public string CommandLine { get; set; }

        /// <summary>
        /// Gets or sets the settings for the container under which the Task
        /// runs.
        /// </summary>
        /// <remarks>
        /// If the Pool that will run this Task has containerConfiguration set,
        /// this must be set as well. If the Pool that will run this Task
        /// doesn't have containerConfiguration set, this must not be set. When
        /// this is specified, all directories recursively below the
        /// AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories on the
        /// node) are mapped into the container, all Task environment variables
        /// are mapped into the container, and the Task command line is
        /// executed in the container. Files produced in the container outside
        /// of AZ_BATCH_NODE_ROOT_DIR might not be reflected to the host disk,
        /// meaning that Batch file APIs will not be able to access those
        /// files.
        /// </remarks>
        [JsonProperty(PropertyName = "containerSettings")]
        public TaskContainerSettings ContainerSettings { get; set; }

        /// <summary>
        /// Gets or sets how the Batch service should respond when the Task
        /// completes.
        /// </summary>
        [JsonProperty(PropertyName = "exitConditions")]
        public ExitConditions ExitConditions { get; set; }

        /// <summary>
        /// Gets or sets a list of files that the Batch service will download
        /// to the Compute Node before running the command line.
        /// </summary>
        /// <remarks>
        /// For multi-instance Tasks, the resource files will only be
        /// downloaded to the Compute Node on which the primary Task is
        /// executed. There is a maximum size for the list of resource files.
        /// When the max size is exceeded, the request will fail and the
        /// response error code will be RequestEntityTooLarge. If this occurs,
        /// the collection of ResourceFiles must be reduced in size. This can
        /// be achieved using .zip files, Application Packages, or Docker
        /// Containers.
        /// </remarks>
        [JsonProperty(PropertyName = "resourceFiles")]
        public IList<ResourceFile> ResourceFiles { get; set; }

        /// <summary>
        /// Gets or sets a list of files that the Batch service will upload
        /// from the Compute Node after running the command line.
        /// </summary>
        /// <remarks>
        /// For multi-instance Tasks, the files will only be uploaded from the
        /// Compute Node on which the primary Task is executed.
        /// </remarks>
        [JsonProperty(PropertyName = "outputFiles")]
        public IList<OutputFile> OutputFiles { get; set; }

        /// <summary>
        /// Gets or sets a list of environment variable settings for the Task.
        /// </summary>
        [JsonProperty(PropertyName = "environmentSettings")]
        public IList<EnvironmentSetting> EnvironmentSettings { get; set; }

        /// <summary>
        /// Gets or sets a locality hint that can be used by the Batch service
        /// to select a Compute Node on which to start the new Task.
        /// </summary>
        [JsonProperty(PropertyName = "affinityInfo")]
        public AffinityInformation AffinityInfo { get; set; }

        /// <summary>
        /// Gets or sets the execution constraints that apply to this Task.
        /// </summary>
        /// <remarks>
        /// If you do not specify constraints, the maxTaskRetryCount is the
        /// maxTaskRetryCount specified for the Job, the maxWallClockTime is
        /// infinite, and the retentionTime is 7 days.
        /// </remarks>
        [JsonProperty(PropertyName = "constraints")]
        public TaskConstraints Constraints { get; set; }

        /// <summary>
        /// Gets or sets the number of scheduling slots that the Task required
        /// to run.
        /// </summary>
        /// <remarks>
        /// The default is 1. A Task can only be scheduled to run on a compute
        /// node if the node has enough free scheduling slots available. For
        /// multi-instance Tasks, this must be 1.
        /// </remarks>
        [JsonProperty(PropertyName = "requiredSlots")]
        public int? RequiredSlots { get; set; }

        /// <summary>
        /// Gets or sets the user identity under which the Task runs.
        /// </summary>
        /// <remarks>
        /// If omitted, the Task runs as a non-administrative user unique to
        /// the Task.
        /// </remarks>
        [JsonProperty(PropertyName = "userIdentity")]
        public UserIdentity UserIdentity { get; set; }

        /// <summary>
        /// Gets or sets an object that indicates that the Task is a
        /// multi-instance Task, and contains information about how to run the
        /// multi-instance Task.
        /// </summary>
        [JsonProperty(PropertyName = "multiInstanceSettings")]
        public MultiInstanceSettings MultiInstanceSettings { get; set; }

        /// <summary>
        /// Gets or sets the Tasks that this Task depends on.
        /// </summary>
        /// <remarks>
        /// This Task will not be scheduled until all Tasks that it depends on
        /// have completed successfully. If any of those Tasks fail and exhaust
        /// their retry counts, this Task will never be scheduled. If the Job
        /// does not have usesTaskDependencies set to true, and this element is
        /// present, the request fails with error code
        /// TaskDependenciesNotSpecifiedOnJob.
        /// </remarks>
        [JsonProperty(PropertyName = "dependsOn")]
        public TaskDependencies DependsOn { get; set; }

        /// <summary>
        /// Gets or sets a list of Packages that the Batch service will deploy
        /// to the Compute Node before running the command line.
        /// </summary>
        /// <remarks>
        /// Application packages are downloaded and deployed to a shared
        /// directory, not the Task working directory. Therefore, if a
        /// referenced package is already on the Node, and is up to date, then
        /// it is not re-downloaded; the existing copy on the Compute Node is
        /// used. If a referenced Package cannot be installed, for example
        /// because the package has been deleted or because download failed,
        /// the Task fails.
        /// </remarks>
        [JsonProperty(PropertyName = "applicationPackageReferences")]
        public IList<ApplicationPackageReference> ApplicationPackageReferences { get; set; }

        /// <summary>
        /// Gets or sets the settings for an authentication token that the Task
        /// can use to perform Batch service operations.
        /// </summary>
        /// <remarks>
        /// If this property is set, the Batch service provides the Task with
        /// an authentication token which can be used to authenticate Batch
        /// service operations without requiring an Account access key. The
        /// token is provided via the AZ_BATCH_AUTHENTICATION_TOKEN environment
        /// variable. The operations that the Task can carry out using the
        /// token depend on the settings. For example, a Task can request Job
        /// permissions in order to add other Tasks to the Job, or check the
        /// status of the Job or of other Tasks under the Job.
        /// </remarks>
        [JsonProperty(PropertyName = "authenticationTokenSettings")]
        public AuthenticationTokenSettings AuthenticationTokenSettings { get; set; }

    }
}
