// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using Newtonsoft.Json.Converters;
    using System.Runtime;
    using System.Runtime.Serialization;

    /// <summary>
    /// Defines values for SecurityTypes.
    /// </summary>
    [JsonConverter(typeof(StringEnumConverter))]
    public enum SecurityTypes
    {
        /// <summary>
        /// Trusted launch protects against advanced and persistent attack
        /// techniques.
        /// </summary>
        [EnumMember(Value = "trustedLaunch")]
        TrustedLaunch,
        /// <summary>
        /// Azure confidential computing offers confidential VMs are for
        /// tenants with high security and confidentiality requirements. These
        /// VMs provide a strong, hardware-enforced boundary to help meet your
        /// security needs. You can use confidential VMs for migrations without
        /// making changes to your code, with the platform protecting your VM's
        /// state from being read or modified.
        /// </summary>
        [EnumMember(Value = "confidentialVM")]
        ConfidentialVM
    }
    internal static class SecurityTypesEnumExtension
    {
        internal static string ToSerializedValue(this SecurityTypes? value)
        {
            return value == null ? null : ((SecurityTypes)value).ToSerializedValue();
        }

        internal static string ToSerializedValue(this SecurityTypes value)
        {
            switch( value )
            {
                case SecurityTypes.TrustedLaunch:
                    return "trustedLaunch";
                case SecurityTypes.ConfidentialVM:
                    return "confidentialVM";
            }
            return null;
        }

        internal static SecurityTypes? ParseSecurityTypes(this string value)
        {
            switch( value )
            {
                case "trustedLaunch":
                    return SecurityTypes.TrustedLaunch;
                case "confidentialVM":
                    return SecurityTypes.ConfidentialVM;
            }
            return null;
        }
    }
}
