// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// Specifies the security profile settings for the virtual machine or
    /// virtual machine scale set.
    /// </summary>
    public partial class SecurityProfile
    {
        /// <summary>
        /// Initializes a new instance of the SecurityProfile class.
        /// </summary>
        public SecurityProfile()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the SecurityProfile class.
        /// </summary>
        /// <param name="securityType">Specifies the SecurityType of the
        /// virtual machine. It has to be set to any specified value to enable
        /// UefiSettings.</param>
        /// <param name="encryptionAtHost">This property can be used by user in
        /// the request to enable or disable the Host Encryption for the
        /// virtual machine or virtual machine scale set. This will enable the
        /// encryption for all the disks including Resource/Temp disk at host
        /// itself. For more information on encryption at host requirements,
        /// please refer to
        /// https://learn.microsoft.com/azure/virtual-machines/disk-encryption#supported-vm-sizes.</param>
        /// <param name="uefiSettings">Specifies the security settings like
        /// secure boot and vTPM used while creating the virtual
        /// machine.</param>
        public SecurityProfile(SecurityTypes? securityType = default(SecurityTypes?), bool? encryptionAtHost = default(bool?), UefiSettings uefiSettings = default(UefiSettings))
        {
            SecurityType = securityType;
            EncryptionAtHost = encryptionAtHost;
            UefiSettings = uefiSettings;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets specifies the SecurityType of the virtual machine. It
        /// has to be set to any specified value to enable UefiSettings.
        /// </summary>
        /// <remarks>
        /// Possible values include: 'trustedLaunch', 'confidentialVM'
        /// </remarks>
        [JsonProperty(PropertyName = "securityType")]
        public SecurityTypes? SecurityType { get; set; }

        /// <summary>
        /// Gets or sets this property can be used by user in the request to
        /// enable or disable the Host Encryption for the virtual machine or
        /// virtual machine scale set. This will enable the encryption for all
        /// the disks including Resource/Temp disk at host itself. For more
        /// information on encryption at host requirements, please refer to
        /// https://learn.microsoft.com/azure/virtual-machines/disk-encryption#supported-vm-sizes.
        /// </summary>
        [JsonProperty(PropertyName = "encryptionAtHost")]
        public bool? EncryptionAtHost { get; set; }

        /// <summary>
        /// Gets or sets specifies the security settings like secure boot and
        /// vTPM used while creating the virtual machine.
        /// </summary>
        /// <remarks>
        /// Specifies the security settings like secure boot and vTPM used
        /// while creating the virtual machine.
        /// </remarks>
        [JsonProperty(PropertyName = "uefiSettings")]
        public UefiSettings UefiSettings { get; set; }

    }
}
