// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using Newtonsoft.Json.Converters;
    using System.Runtime;
    using System.Runtime.Serialization;

    /// <summary>
    /// Defines values for SchedulingState.
    /// </summary>
    [JsonConverter(typeof(StringEnumConverter))]
    public enum SchedulingState
    {
        /// <summary>
        /// Tasks can be scheduled on the Compute Node.
        /// </summary>
        [EnumMember(Value = "enabled")]
        Enabled,
        /// <summary>
        /// No new Tasks will be scheduled on the Compute Node. Tasks already
        /// running on the Compute Node may still run to completion. All
        /// Compute Nodes start with scheduling enabled.
        /// </summary>
        [EnumMember(Value = "disabled")]
        Disabled
    }
    internal static class SchedulingStateEnumExtension
    {
        internal static string ToSerializedValue(this SchedulingState? value)
        {
            return value == null ? null : ((SchedulingState)value).ToSerializedValue();
        }

        internal static string ToSerializedValue(this SchedulingState value)
        {
            switch( value )
            {
                case SchedulingState.Enabled:
                    return "enabled";
                case SchedulingState.Disabled:
                    return "disabled";
            }
            return null;
        }

        internal static SchedulingState? ParseSchedulingState(this string value)
        {
            switch( value )
            {
                case "enabled":
                    return SchedulingState.Enabled;
                case "disabled":
                    return SchedulingState.Disabled;
            }
            return null;
        }
    }
}
