// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// The configuration parameters used while performing a rolling upgrade.
    /// </summary>
    public partial class RollingUpgradePolicy
    {
        /// <summary>
        /// Initializes a new instance of the RollingUpgradePolicy class.
        /// </summary>
        public RollingUpgradePolicy()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the RollingUpgradePolicy class.
        /// </summary>
        /// <param name="enableCrossZoneUpgrade">Allow VMSS to ignore AZ
        /// boundaries when constructing upgrade batches. Take into
        /// consideration the Update Domain and maxBatchInstancePercent to
        /// determine the batch size. This field is able to be set to true or
        /// false only when using NodePlacementConfiguration as Zonal.</param>
        /// <param name="maxBatchInstancePercent">The maximum percent of total
        /// virtual machine instances that will be upgraded simultaneously by
        /// the rolling upgrade in one batch. As this is a maximum, unhealthy
        /// instances in previous or future batches can cause the percentage of
        /// instances in a batch to decrease to ensure higher reliability. The
        /// value of this field should be between 5 and 100, inclusive. If both
        /// maxBatchInstancePercent and maxUnhealthyInstancePercent are
        /// assigned with value, the value of maxBatchInstancePercent should
        /// not be more than maxUnhealthyInstancePercent.</param>
        /// <param name="maxUnhealthyInstancePercent">The maximum percentage of
        /// the total virtual machine instances in the scale set that can be
        /// simultaneously unhealthy, either as a result of being upgraded, or
        /// by being found in an unhealthy state by the virtual machine health
        /// checks before the rolling upgrade aborts. This constraint will be
        /// checked prior to starting any batch. The value of this field should
        /// be between 5 and 100, inclusive. If both maxBatchInstancePercent
        /// and maxUnhealthyInstancePercent are assigned with value, the value
        /// of maxBatchInstancePercent should not be more than
        /// maxUnhealthyInstancePercent.</param>
        /// <param name="maxUnhealthyUpgradedInstancePercent">The maximum
        /// percentage of upgraded virtual machine instances that can be found
        /// to be in an unhealthy state. This check will happen after each
        /// batch is upgraded. If this percentage is ever exceeded, the rolling
        /// update aborts. The value of this field should be between 0 and 100,
        /// inclusive.</param>
        /// <param name="pauseTimeBetweenBatches">The wait time between
        /// completing the update for all virtual machines in one batch and
        /// starting the next batch. The time duration should be specified in
        /// ISO 8601 format.</param>
        /// <param name="prioritizeUnhealthyInstances">Upgrade all unhealthy
        /// instances in a scale set before any healthy instances.</param>
        /// <param name="rollbackFailedInstancesOnPolicyBreach">Rollback failed
        /// instances to previous model if the Rolling Upgrade policy is
        /// violated.</param>
        public RollingUpgradePolicy(bool? enableCrossZoneUpgrade = default(bool?), int? maxBatchInstancePercent = default(int?), int? maxUnhealthyInstancePercent = default(int?), int? maxUnhealthyUpgradedInstancePercent = default(int?), System.TimeSpan? pauseTimeBetweenBatches = default(System.TimeSpan?), bool? prioritizeUnhealthyInstances = default(bool?), bool? rollbackFailedInstancesOnPolicyBreach = default(bool?))
        {
            EnableCrossZoneUpgrade = enableCrossZoneUpgrade;
            MaxBatchInstancePercent = maxBatchInstancePercent;
            MaxUnhealthyInstancePercent = maxUnhealthyInstancePercent;
            MaxUnhealthyUpgradedInstancePercent = maxUnhealthyUpgradedInstancePercent;
            PauseTimeBetweenBatches = pauseTimeBetweenBatches;
            PrioritizeUnhealthyInstances = prioritizeUnhealthyInstances;
            RollbackFailedInstancesOnPolicyBreach = rollbackFailedInstancesOnPolicyBreach;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets allow VMSS to ignore AZ boundaries when constructing
        /// upgrade batches. Take into consideration the Update Domain and
        /// maxBatchInstancePercent to determine the batch size. This field is
        /// able to be set to true or false only when using
        /// NodePlacementConfiguration as Zonal.
        /// </summary>
        [JsonProperty(PropertyName = "enableCrossZoneUpgrade")]
        public bool? EnableCrossZoneUpgrade { get; set; }

        /// <summary>
        /// Gets or sets the maximum percent of total virtual machine instances
        /// that will be upgraded simultaneously by the rolling upgrade in one
        /// batch. As this is a maximum, unhealthy instances in previous or
        /// future batches can cause the percentage of instances in a batch to
        /// decrease to ensure higher reliability. The value of this field
        /// should be between 5 and 100, inclusive. If both
        /// maxBatchInstancePercent and maxUnhealthyInstancePercent are
        /// assigned with value, the value of maxBatchInstancePercent should
        /// not be more than maxUnhealthyInstancePercent.
        /// </summary>
        [JsonProperty(PropertyName = "maxBatchInstancePercent")]
        public int? MaxBatchInstancePercent { get; set; }

        /// <summary>
        /// Gets or sets the maximum percentage of the total virtual machine
        /// instances in the scale set that can be simultaneously unhealthy,
        /// either as a result of being upgraded, or by being found in an
        /// unhealthy state by the virtual machine health checks before the
        /// rolling upgrade aborts. This constraint will be checked prior to
        /// starting any batch. The value of this field should be between 5 and
        /// 100, inclusive. If both maxBatchInstancePercent and
        /// maxUnhealthyInstancePercent are assigned with value, the value of
        /// maxBatchInstancePercent should not be more than
        /// maxUnhealthyInstancePercent.
        /// </summary>
        [JsonProperty(PropertyName = "maxUnhealthyInstancePercent")]
        public int? MaxUnhealthyInstancePercent { get; set; }

        /// <summary>
        /// Gets or sets the maximum percentage of upgraded virtual machine
        /// instances that can be found to be in an unhealthy state. This check
        /// will happen after each batch is upgraded. If this percentage is
        /// ever exceeded, the rolling update aborts. The value of this field
        /// should be between 0 and 100, inclusive.
        /// </summary>
        [JsonProperty(PropertyName = "maxUnhealthyUpgradedInstancePercent")]
        public int? MaxUnhealthyUpgradedInstancePercent { get; set; }

        /// <summary>
        /// Gets or sets the wait time between completing the update for all
        /// virtual machines in one batch and starting the next batch. The time
        /// duration should be specified in ISO 8601 format.
        /// </summary>
        [JsonProperty(PropertyName = "pauseTimeBetweenBatches")]
        public System.TimeSpan? PauseTimeBetweenBatches { get; set; }

        /// <summary>
        /// Gets or sets upgrade all unhealthy instances in a scale set before
        /// any healthy instances.
        /// </summary>
        [JsonProperty(PropertyName = "prioritizeUnhealthyInstances")]
        public bool? PrioritizeUnhealthyInstances { get; set; }

        /// <summary>
        /// Gets or sets rollback failed instances to previous model if the
        /// Rolling Upgrade policy is violated.
        /// </summary>
        [JsonProperty(PropertyName = "rollbackFailedInstancesOnPolicyBreach")]
        public bool? RollbackFailedInstancesOnPolicyBreach { get; set; }

    }
}
