// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// Statistics related to resource consumption by Compute Nodes in a Pool.
    /// </summary>
    public partial class ResourceStatistics
    {
        /// <summary>
        /// Initializes a new instance of the ResourceStatistics class.
        /// </summary>
        public ResourceStatistics()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the ResourceStatistics class.
        /// </summary>
        /// <param name="startTime">The start time of the time range covered by
        /// the statistics.</param>
        /// <param name="lastUpdateTime">The time at which the statistics were
        /// last updated. All statistics are limited to the range between
        /// startTime and lastUpdateTime.</param>
        /// <param name="avgCPUPercentage">The average CPU usage across all
        /// Compute Nodes in the Pool (percentage per node).</param>
        /// <param name="avgMemoryGiB">The average memory usage in GiB across
        /// all Compute Nodes in the Pool.</param>
        /// <param name="peakMemoryGiB">The peak memory usage in GiB across all
        /// Compute Nodes in the Pool.</param>
        /// <param name="avgDiskGiB">The average used disk space in GiB across
        /// all Compute Nodes in the Pool.</param>
        /// <param name="peakDiskGiB">The peak used disk space in GiB across
        /// all Compute Nodes in the Pool.</param>
        /// <param name="diskReadIOps">The total number of disk read operations
        /// across all Compute Nodes in the Pool.</param>
        /// <param name="diskWriteIOps">The total number of disk write
        /// operations across all Compute Nodes in the Pool.</param>
        /// <param name="diskReadGiB">The total amount of data in GiB of disk
        /// reads across all Compute Nodes in the Pool.</param>
        /// <param name="diskWriteGiB">The total amount of data in GiB of disk
        /// writes across all Compute Nodes in the Pool.</param>
        /// <param name="networkReadGiB">The total amount of data in GiB of
        /// network reads across all Compute Nodes in the Pool.</param>
        /// <param name="networkWriteGiB">The total amount of data in GiB of
        /// network writes across all Compute Nodes in the Pool.</param>
        public ResourceStatistics(System.DateTime startTime, System.DateTime lastUpdateTime, double avgCPUPercentage, double avgMemoryGiB, double peakMemoryGiB, double avgDiskGiB, double peakDiskGiB, long diskReadIOps, long diskWriteIOps, double diskReadGiB, double diskWriteGiB, double networkReadGiB, double networkWriteGiB)
        {
            StartTime = startTime;
            LastUpdateTime = lastUpdateTime;
            AvgCPUPercentage = avgCPUPercentage;
            AvgMemoryGiB = avgMemoryGiB;
            PeakMemoryGiB = peakMemoryGiB;
            AvgDiskGiB = avgDiskGiB;
            PeakDiskGiB = peakDiskGiB;
            DiskReadIOps = diskReadIOps;
            DiskWriteIOps = diskWriteIOps;
            DiskReadGiB = diskReadGiB;
            DiskWriteGiB = diskWriteGiB;
            NetworkReadGiB = networkReadGiB;
            NetworkWriteGiB = networkWriteGiB;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the start time of the time range covered by the
        /// statistics.
        /// </summary>
        [JsonProperty(PropertyName = "startTime")]
        public System.DateTime StartTime { get; set; }

        /// <summary>
        /// Gets or sets the time at which the statistics were last updated.
        /// All statistics are limited to the range between startTime and
        /// lastUpdateTime.
        /// </summary>
        [JsonProperty(PropertyName = "lastUpdateTime")]
        public System.DateTime LastUpdateTime { get; set; }

        /// <summary>
        /// Gets or sets the average CPU usage across all Compute Nodes in the
        /// Pool (percentage per node).
        /// </summary>
        [JsonProperty(PropertyName = "avgCPUPercentage")]
        public double AvgCPUPercentage { get; set; }

        /// <summary>
        /// Gets or sets the average memory usage in GiB across all Compute
        /// Nodes in the Pool.
        /// </summary>
        [JsonProperty(PropertyName = "avgMemoryGiB")]
        public double AvgMemoryGiB { get; set; }

        /// <summary>
        /// Gets or sets the peak memory usage in GiB across all Compute Nodes
        /// in the Pool.
        /// </summary>
        [JsonProperty(PropertyName = "peakMemoryGiB")]
        public double PeakMemoryGiB { get; set; }

        /// <summary>
        /// Gets or sets the average used disk space in GiB across all Compute
        /// Nodes in the Pool.
        /// </summary>
        [JsonProperty(PropertyName = "avgDiskGiB")]
        public double AvgDiskGiB { get; set; }

        /// <summary>
        /// Gets or sets the peak used disk space in GiB across all Compute
        /// Nodes in the Pool.
        /// </summary>
        [JsonProperty(PropertyName = "peakDiskGiB")]
        public double PeakDiskGiB { get; set; }

        /// <summary>
        /// Gets or sets the total number of disk read operations across all
        /// Compute Nodes in the Pool.
        /// </summary>
        [JsonProperty(PropertyName = "diskReadIOps")]
        public long DiskReadIOps { get; set; }

        /// <summary>
        /// Gets or sets the total number of disk write operations across all
        /// Compute Nodes in the Pool.
        /// </summary>
        [JsonProperty(PropertyName = "diskWriteIOps")]
        public long DiskWriteIOps { get; set; }

        /// <summary>
        /// Gets or sets the total amount of data in GiB of disk reads across
        /// all Compute Nodes in the Pool.
        /// </summary>
        [JsonProperty(PropertyName = "diskReadGiB")]
        public double DiskReadGiB { get; set; }

        /// <summary>
        /// Gets or sets the total amount of data in GiB of disk writes across
        /// all Compute Nodes in the Pool.
        /// </summary>
        [JsonProperty(PropertyName = "diskWriteGiB")]
        public double DiskWriteGiB { get; set; }

        /// <summary>
        /// Gets or sets the total amount of data in GiB of network reads
        /// across all Compute Nodes in the Pool.
        /// </summary>
        [JsonProperty(PropertyName = "networkReadGiB")]
        public double NetworkReadGiB { get; set; }

        /// <summary>
        /// Gets or sets the total amount of data in GiB of network writes
        /// across all Compute Nodes in the Pool.
        /// </summary>
        [JsonProperty(PropertyName = "networkWriteGiB")]
        public double NetworkWriteGiB { get; set; }

    }
}
