// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// The public IP Address configuration of the networking configuration of
    /// a Pool.
    /// </summary>
    public partial class PublicIPAddressConfiguration
    {
        /// <summary>
        /// Initializes a new instance of the PublicIPAddressConfiguration
        /// class.
        /// </summary>
        public PublicIPAddressConfiguration()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the PublicIPAddressConfiguration
        /// class.
        /// </summary>
        /// <param name="provision">The provisioning type for Public IP
        /// Addresses for the Pool.</param>
        /// <param name="ipAddressIds">The list of public IPs which the Batch
        /// service will use when provisioning Compute Nodes.</param>
        public PublicIPAddressConfiguration(IPAddressProvisioningType? provision = default(IPAddressProvisioningType?), IList<string> ipAddressIds = default(IList<string>))
        {
            Provision = provision;
            IpAddressIds = ipAddressIds;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the provisioning type for Public IP Addresses for the
        /// Pool.
        /// </summary>
        /// <remarks>
        /// The default value is BatchManaged. Possible values include:
        /// 'batchManaged', 'userManaged', 'noPublicIPAddresses'
        /// </remarks>
        [JsonProperty(PropertyName = "provision")]
        public IPAddressProvisioningType? Provision { get; set; }

        /// <summary>
        /// Gets or sets the list of public IPs which the Batch service will
        /// use when provisioning Compute Nodes.
        /// </summary>
        /// <remarks>
        /// The number of IPs specified here limits the maximum size of the
        /// Pool - 100 dedicated nodes or 100 Spot/Low-priority nodes can be
        /// allocated for each public IP. For example, a pool needing 250
        /// dedicated VMs would need at least 3 public IPs specified. Each
        /// element of this collection is of the form:
        /// /subscriptions/{subscription}/resourceGroups/{group}/providers/Microsoft.Network/publicIPAddresses/{ip}.
        /// </remarks>
        [JsonProperty(PropertyName = "ipAddressIds")]
        public IList<string> IpAddressIds { get; set; }

    }
}
