// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// The set of changes to be made to a Pool.
    /// </summary>
    public partial class PoolUpdatePropertiesParameter
    {
        /// <summary>
        /// Initializes a new instance of the PoolUpdatePropertiesParameter
        /// class.
        /// </summary>
        public PoolUpdatePropertiesParameter()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the PoolUpdatePropertiesParameter
        /// class.
        /// </summary>
        /// <param name="certificateReferences">A list of Certificates to be
        /// installed on each Compute Node in the Pool.</param>
        /// <param name="applicationPackageReferences">The list of Application
        /// Packages to be installed on each Compute Node in the Pool.</param>
        /// <param name="metadata">A list of name-value pairs associated with
        /// the Pool as metadata.</param>
        /// <param name="startTask">A Task to run on each Compute Node as it
        /// joins the Pool. The Task runs when the Compute Node is added to the
        /// Pool or when the Compute Node is restarted.</param>
        /// <param name="targetNodeCommunicationMode">The desired node
        /// communication mode for the pool.</param>
        public PoolUpdatePropertiesParameter(IList<CertificateReference> certificateReferences, IList<ApplicationPackageReference> applicationPackageReferences, IList<MetadataItem> metadata, StartTask startTask = default(StartTask), NodeCommunicationMode? targetNodeCommunicationMode = default(NodeCommunicationMode?))
        {
            StartTask = startTask;
            CertificateReferences = certificateReferences;
            ApplicationPackageReferences = applicationPackageReferences;
            Metadata = metadata;
            TargetNodeCommunicationMode = targetNodeCommunicationMode;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets a Task to run on each Compute Node as it joins the
        /// Pool. The Task runs when the Compute Node is added to the Pool or
        /// when the Compute Node is restarted.
        /// </summary>
        /// <remarks>
        /// If this element is present, it overwrites any existing StartTask.
        /// If omitted, any existing StartTask is removed from the Pool.
        /// </remarks>
        [JsonProperty(PropertyName = "startTask")]
        public StartTask StartTask { get; set; }

        /// <summary>
        /// Gets or sets a list of Certificates to be installed on each Compute
        /// Node in the Pool.
        /// </summary>
        /// <remarks>
        /// This list replaces any existing Certificate references configured
        /// on the Pool. If you specify an empty collection, any existing
        /// Certificate references are removed from the Pool. For Windows
        /// Nodes, the Batch service installs the Certificates to the specified
        /// Certificate store and location. For Linux Compute Nodes, the
        /// Certificates are stored in a directory inside the Task working
        /// directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is
        /// supplied to the Task to query for this location. For Certificates
        /// with visibility of 'remoteUser', a 'certs' directory is created in
        /// the user's home directory (e.g., /home/{user-name}/certs) and
        /// Certificates are placed in that directory.
        ///
        /// Warning: This property is deprecated and will be removed after
        /// February, 2024. Please use the [Azure KeyVault
        /// Extension](https://learn.microsoft.com/azure/batch/batch-certificate-migration-guide)
        /// instead.
        /// </remarks>
        [JsonProperty(PropertyName = "certificateReferences")]
        public IList<CertificateReference> CertificateReferences { get; set; }

        /// <summary>
        /// Gets or sets the list of Application Packages to be installed on
        /// each Compute Node in the Pool.
        /// </summary>
        /// <remarks>
        /// The list replaces any existing Application Package references on
        /// the Pool. Changes to Application Package references affect all new
        /// Compute Nodes joining the Pool, but do not affect Compute Nodes
        /// that are already in the Pool until they are rebooted or reimaged.
        /// There is a maximum of 10 Application Package references on any
        /// given Pool. If omitted, or if you specify an empty collection, any
        /// existing Application Packages references are removed from the Pool.
        /// A maximum of 10 references may be specified on a given Pool.
        /// </remarks>
        [JsonProperty(PropertyName = "applicationPackageReferences")]
        public IList<ApplicationPackageReference> ApplicationPackageReferences { get; set; }

        /// <summary>
        /// Gets or sets a list of name-value pairs associated with the Pool as
        /// metadata.
        /// </summary>
        /// <remarks>
        /// This list replaces any existing metadata configured on the Pool. If
        /// omitted, or if you specify an empty collection, any existing
        /// metadata is removed from the Pool.
        /// </remarks>
        [JsonProperty(PropertyName = "metadata")]
        public IList<MetadataItem> Metadata { get; set; }

        /// <summary>
        /// Gets or sets the desired node communication mode for the pool.
        /// </summary>
        /// <remarks>
        /// This setting replaces any existing targetNodeCommunication setting
        /// on the Pool. If omitted, the existing setting is default. Possible
        /// values include: 'default', 'classic', 'simplified'
        /// </remarks>
        [JsonProperty(PropertyName = "targetNodeCommunicationMode")]
        public NodeCommunicationMode? TargetNodeCommunicationMode { get; set; }

    }
}
