// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using Newtonsoft.Json.Converters;
    using System.Runtime;
    using System.Runtime.Serialization;

    /// <summary>
    /// Defines values for PoolState.
    /// </summary>
    [JsonConverter(typeof(StringEnumConverter))]
    public enum PoolState
    {
        /// <summary>
        /// The Pool is available to run Tasks subject to the availability of
        /// Compute Nodes.
        /// </summary>
        [EnumMember(Value = "active")]
        Active,
        /// <summary>
        /// The user has requested that the Pool be deleted, but the delete
        /// operation has not yet completed.
        /// </summary>
        [EnumMember(Value = "deleting")]
        Deleting
    }
    internal static class PoolStateEnumExtension
    {
        internal static string ToSerializedValue(this PoolState? value)
        {
            return value == null ? null : ((PoolState)value).ToSerializedValue();
        }

        internal static string ToSerializedValue(this PoolState value)
        {
            switch( value )
            {
                case PoolState.Active:
                    return "active";
                case PoolState.Deleting:
                    return "deleting";
            }
            return null;
        }

        internal static PoolState? ParsePoolState(this string value)
        {
            switch( value )
            {
                case "active":
                    return PoolState.Active;
                case "deleting":
                    return PoolState.Deleting;
            }
            return null;
        }
    }
}
