// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// Options for changing the size of a Pool.
    /// </summary>
    public partial class PoolResizeParameter
    {
        /// <summary>
        /// Initializes a new instance of the PoolResizeParameter class.
        /// </summary>
        public PoolResizeParameter()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the PoolResizeParameter class.
        /// </summary>
        /// <param name="targetDedicatedNodes">The desired number of dedicated
        /// Compute Nodes in the Pool.</param>
        /// <param name="targetLowPriorityNodes">The desired number of
        /// Spot/Low-priority Compute Nodes in the Pool.</param>
        /// <param name="resizeTimeout">The timeout for allocation of Nodes to
        /// the Pool or removal of Compute Nodes from the Pool.</param>
        /// <param name="nodeDeallocationOption">Determines what to do with a
        /// Compute Node and its running task(s) if the Pool size is
        /// decreasing.</param>
        public PoolResizeParameter(int? targetDedicatedNodes = default(int?), int? targetLowPriorityNodes = default(int?), System.TimeSpan? resizeTimeout = default(System.TimeSpan?), ComputeNodeDeallocationOption? nodeDeallocationOption = default(ComputeNodeDeallocationOption?))
        {
            TargetDedicatedNodes = targetDedicatedNodes;
            TargetLowPriorityNodes = targetLowPriorityNodes;
            ResizeTimeout = resizeTimeout;
            NodeDeallocationOption = nodeDeallocationOption;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the desired number of dedicated Compute Nodes in the
        /// Pool.
        /// </summary>
        [JsonProperty(PropertyName = "targetDedicatedNodes")]
        public int? TargetDedicatedNodes { get; set; }

        /// <summary>
        /// Gets or sets the desired number of Spot/Low-priority Compute Nodes
        /// in the Pool.
        /// </summary>
        [JsonProperty(PropertyName = "targetLowPriorityNodes")]
        public int? TargetLowPriorityNodes { get; set; }

        /// <summary>
        /// Gets or sets the timeout for allocation of Nodes to the Pool or
        /// removal of Compute Nodes from the Pool.
        /// </summary>
        /// <remarks>
        /// The default value is 15 minutes. The minimum value is 5 minutes. If
        /// you specify a value less than 5 minutes, the Batch service returns
        /// an error; if you are calling the REST API directly, the HTTP status
        /// code is 400 (Bad Request).
        /// </remarks>
        [JsonProperty(PropertyName = "resizeTimeout")]
        public System.TimeSpan? ResizeTimeout { get; set; }

        /// <summary>
        /// Gets or sets determines what to do with a Compute Node and its
        /// running task(s) if the Pool size is decreasing.
        /// </summary>
        /// <remarks>
        /// The default value is requeue. Possible values include: 'requeue',
        /// 'terminate', 'taskCompletion', 'retainedData'
        /// </remarks>
        [JsonProperty(PropertyName = "nodeDeallocationOption")]
        public ComputeNodeDeallocationOption? NodeDeallocationOption { get; set; }

    }
}
