// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// The set of changes to be made to a Pool.
    /// </summary>
    public partial class PoolPatchParameter
    {
        /// <summary>
        /// Initializes a new instance of the PoolPatchParameter class.
        /// </summary>
        public PoolPatchParameter()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the PoolPatchParameter class.
        /// </summary>
        /// <param name="startTask">A Task to run on each Compute Node as it
        /// joins the Pool. The Task runs when the Compute Node is added to the
        /// Pool or when the Compute Node is restarted.</param>
        /// <param name="certificateReferences">A list of Certificates to be
        /// installed on each Compute Node in the Pool.</param>
        /// <param name="applicationPackageReferences">A list of Packages to be
        /// installed on each Compute Node in the Pool.</param>
        /// <param name="metadata">A list of name-value pairs associated with
        /// the Pool as metadata.</param>
        /// <param name="targetNodeCommunicationMode">The desired node
        /// communication mode for the pool.</param>
        /// <param name="displayName">The display name for the Pool.</param>
        /// <param name="vmSize">The size of virtual machines in the Pool. All
        /// VMs in a Pool are the same size.</param>
        /// <param name="taskSlotsPerNode">The number of task slots that can be
        /// used to run concurrent tasks on a single compute node in the
        /// pool.</param>
        /// <param name="taskSchedulingPolicy">How Tasks are distributed across
        /// Compute Nodes in a Pool.</param>
        /// <param name="enableInterNodeCommunication">Whether the Pool permits
        /// direct communication between Compute Nodes.</param>
        /// <param name="virtualMachineConfiguration">The virtual machine
        /// configuration for the Pool.</param>
        /// <param name="networkConfiguration">The network configuration for
        /// the Pool.</param>
        /// <param name="userAccounts">The list of user Accounts to be created
        /// on each Compute Node in the Pool.</param>
        /// <param name="mountConfiguration">Mount storage using specified file
        /// system for the entire lifetime of the pool.</param>
        /// <param name="upgradePolicy">The upgrade policy for the
        /// Pool.</param>
        /// <param name="resourceTags">The user-specified tags associated with
        /// the pool.</param>
        public PoolPatchParameter(StartTask startTask = default(StartTask), IList<CertificateReference> certificateReferences = default(IList<CertificateReference>), IList<ApplicationPackageReference> applicationPackageReferences = default(IList<ApplicationPackageReference>), IList<MetadataItem> metadata = default(IList<MetadataItem>), NodeCommunicationMode? targetNodeCommunicationMode = default(NodeCommunicationMode?), string displayName = default(string), string vmSize = default(string), int? taskSlotsPerNode = default(int?), TaskSchedulingPolicy taskSchedulingPolicy = default(TaskSchedulingPolicy), bool? enableInterNodeCommunication = default(bool?), VirtualMachineConfiguration virtualMachineConfiguration = default(VirtualMachineConfiguration), NetworkConfiguration networkConfiguration = default(NetworkConfiguration), IList<UserAccount> userAccounts = default(IList<UserAccount>), IList<MountConfiguration> mountConfiguration = default(IList<MountConfiguration>), UpgradePolicy upgradePolicy = default(UpgradePolicy), IDictionary<string, string> resourceTags = default(IDictionary<string, string>))
        {
            StartTask = startTask;
            CertificateReferences = certificateReferences;
            ApplicationPackageReferences = applicationPackageReferences;
            Metadata = metadata;
            TargetNodeCommunicationMode = targetNodeCommunicationMode;
            DisplayName = displayName;
            VmSize = vmSize;
            TaskSlotsPerNode = taskSlotsPerNode;
            TaskSchedulingPolicy = taskSchedulingPolicy;
            EnableInterNodeCommunication = enableInterNodeCommunication;
            VirtualMachineConfiguration = virtualMachineConfiguration;
            NetworkConfiguration = networkConfiguration;
            UserAccounts = userAccounts;
            MountConfiguration = mountConfiguration;
            UpgradePolicy = upgradePolicy;
            ResourceTags = resourceTags;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets a Task to run on each Compute Node as it joins the
        /// Pool. The Task runs when the Compute Node is added to the Pool or
        /// when the Compute Node is restarted.
        /// </summary>
        /// <remarks>
        /// If this element is present, it overwrites any existing StartTask.
        /// If omitted, any existing StartTask is left unchanged.
        /// </remarks>
        [JsonProperty(PropertyName = "startTask")]
        public StartTask StartTask { get; set; }

        /// <summary>
        /// Gets or sets a list of Certificates to be installed on each Compute
        /// Node in the Pool.
        /// </summary>
        /// <remarks>
        /// If this element is present, it replaces any existing Certificate
        /// references configured on the Pool. If omitted, any existing
        /// Certificate references are left unchanged. For Windows Nodes, the
        /// Batch service installs the Certificates to the specified
        /// Certificate store and location. For Linux Compute Nodes, the
        /// Certificates are stored in a directory inside the Task working
        /// directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is
        /// supplied to the Task to query for this location. For Certificates
        /// with visibility of 'remoteUser', a 'certs' directory is created in
        /// the user's home directory (e.g., /home/{user-name}/certs) and
        /// Certificates are placed in that directory.
        ///
        /// Warning: This property is deprecated and will be removed after
        /// February, 2024. Please use the [Azure KeyVault
        /// Extension](https://learn.microsoft.com/azure/batch/batch-certificate-migration-guide)
        /// instead.
        /// </remarks>
        [JsonProperty(PropertyName = "certificateReferences")]
        public IList<CertificateReference> CertificateReferences { get; set; }

        /// <summary>
        /// Gets or sets a list of Packages to be installed on each Compute
        /// Node in the Pool.
        /// </summary>
        /// <remarks>
        /// Changes to Package references affect all new Nodes joining the
        /// Pool, but do not affect Compute Nodes that are already in the Pool
        /// until they are rebooted or reimaged. If this element is present, it
        /// replaces any existing Package references. If you specify an empty
        /// collection, then all Package references are removed from the Pool.
        /// If omitted, any existing Package references are left unchanged.
        /// </remarks>
        [JsonProperty(PropertyName = "applicationPackageReferences")]
        public IList<ApplicationPackageReference> ApplicationPackageReferences { get; set; }

        /// <summary>
        /// Gets or sets a list of name-value pairs associated with the Pool as
        /// metadata.
        /// </summary>
        /// <remarks>
        /// If this element is present, it replaces any existing metadata
        /// configured on the Pool. If you specify an empty collection, any
        /// metadata is removed from the Pool. If omitted, any existing
        /// metadata is left unchanged.
        /// </remarks>
        [JsonProperty(PropertyName = "metadata")]
        public IList<MetadataItem> Metadata { get; set; }

        /// <summary>
        /// Gets or sets the desired node communication mode for the pool.
        /// </summary>
        /// <remarks>
        /// If this element is present, it replaces the existing
        /// targetNodeCommunicationMode configured on the Pool. If omitted, any
        /// existing metadata is left unchanged. Possible values include:
        /// 'default', 'classic', 'simplified'
        /// </remarks>
        [JsonProperty(PropertyName = "targetNodeCommunicationMode")]
        public NodeCommunicationMode? TargetNodeCommunicationMode { get; set; }

        /// <summary>
        /// Gets or sets the display name for the Pool.
        /// </summary>
        /// <remarks>
        /// The display name need not be unique and can contain any Unicode
        /// characters up to a maximum length of 1024.<br /><br />This field
        /// can be updated only when the pool is empty.
        /// </remarks>
        [JsonProperty(PropertyName = "displayName")]
        public string DisplayName { get; set; }

        /// <summary>
        /// Gets or sets the size of virtual machines in the Pool. All VMs in a
        /// Pool are the same size.
        /// </summary>
        /// <remarks>
        /// For information about available sizes of virtual machines in Pools,
        /// see Choose a VM size for Compute Nodes in an Azure Batch Pool
        /// (https://docs.microsoft.com/azure/batch/batch-pool-vm-sizes).<br
        /// /><br />This field can be updated only when the pool is empty.
        /// </remarks>
        [JsonProperty(PropertyName = "vmSize")]
        public string VmSize { get; set; }

        /// <summary>
        /// Gets or sets the number of task slots that can be used to run
        /// concurrent tasks on a single compute node in the pool.
        /// </summary>
        /// <remarks>
        /// The default value is 1. The maximum value is the smaller of 4 times
        /// the number of cores of the vmSize of the pool or 256.<br /><br
        /// />This field can be updated only when the pool is empty.
        /// </remarks>
        [JsonProperty(PropertyName = "taskSlotsPerNode")]
        public int? TaskSlotsPerNode { get; set; }

        /// <summary>
        /// Gets or sets how Tasks are distributed across Compute Nodes in a
        /// Pool.
        /// </summary>
        /// <remarks>
        /// If not specified, the default is spread.<br /><br />This field can
        /// be updated only when the pool is empty.
        /// </remarks>
        [JsonProperty(PropertyName = "taskSchedulingPolicy")]
        public TaskSchedulingPolicy TaskSchedulingPolicy { get; set; }

        /// <summary>
        /// Gets or sets whether the Pool permits direct communication between
        /// Compute Nodes.
        /// </summary>
        /// <remarks>
        /// Enabling inter-node communication limits the maximum size of the
        /// Pool due to deployment restrictions on the Compute Nodes of the
        /// Pool. This may result in the Pool not reaching its desired size.
        /// The default value is false.<br /><br />This field can be updated
        /// only when the pool is empty.
        /// </remarks>
        [JsonProperty(PropertyName = "enableInterNodeCommunication")]
        public bool? EnableInterNodeCommunication { get; set; }

        /// <summary>
        /// Gets or sets the virtual machine configuration for the Pool.
        /// </summary>
        /// <remarks>
        /// This property must be specified.<br /><br />This field can be
        /// updated only when the pool is empty.
        /// </remarks>
        [JsonProperty(PropertyName = "virtualMachineConfiguration")]
        public VirtualMachineConfiguration VirtualMachineConfiguration { get; set; }

        /// <summary>
        /// Gets or sets the network configuration for the Pool.
        /// </summary>
        /// <remarks>
        /// This field can be updated only when the pool is empty.
        /// </remarks>
        [JsonProperty(PropertyName = "networkConfiguration")]
        public NetworkConfiguration NetworkConfiguration { get; set; }

        /// <summary>
        /// Gets or sets the list of user Accounts to be created on each
        /// Compute Node in the Pool.
        /// </summary>
        /// <remarks>
        /// This field can be updated only when the pool is empty.
        /// </remarks>
        [JsonProperty(PropertyName = "userAccounts")]
        public IList<UserAccount> UserAccounts { get; set; }

        /// <summary>
        /// Gets or sets mount storage using specified file system for the
        /// entire lifetime of the pool.
        /// </summary>
        /// <remarks>
        /// Mount the storage using Azure fileshare, NFS, CIFS or Blobfuse
        /// based file system.<br /><br />This field can be updated only when
        /// the pool is empty.
        /// </remarks>
        [JsonProperty(PropertyName = "mountConfiguration")]
        public IList<MountConfiguration> MountConfiguration { get; set; }

        /// <summary>
        /// Gets or sets the upgrade policy for the Pool.
        /// </summary>
        /// <remarks>
        /// Describes an upgrade policy - automatic, manual, or rolling.<br
        /// /><br />This field can be updated only when the pool is empty.
        /// </remarks>
        [JsonProperty(PropertyName = "upgradePolicy")]
        public UpgradePolicy UpgradePolicy { get; set; }

        /// <summary>
        /// Gets or sets the user-specified tags associated with the pool.
        /// </summary>
        /// <remarks>
        /// The user-defined tags to be associated with the Azure Batch Pool.
        /// When specified, these tags are propagated to the backing Azure
        /// resources associated with the pool. This property can only be
        /// specified when the Batch account was created with the
        /// poolAllocationMode property set to 'UserSubscription'.<br /><br
        /// />This field can be updated only when the pool is empty.
        /// </remarks>
        [JsonProperty(PropertyName = "resourceTags")]
        public IDictionary<string, string> ResourceTags { get; set; }

    }
}
