// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using Newtonsoft.Json.Converters;
    using System.Runtime;
    using System.Runtime.Serialization;

    /// <summary>
    /// Defines values for PoolLifetimeOption.
    /// </summary>
    [JsonConverter(typeof(StringEnumConverter))]
    public enum PoolLifetimeOption
    {
        /// <summary>
        /// The Pool exists for the lifetime of the Job Schedule. The Batch
        /// Service creates the Pool when it creates the first Job on the
        /// schedule. You may apply this option only to Job Schedules, not to
        /// Jobs.
        /// </summary>
        [EnumMember(Value = "jobschedule")]
        JobSchedule,
        /// <summary>
        /// The Pool exists for the lifetime of the Job to which it is
        /// dedicated. The Batch service creates the Pool when it creates the
        /// Job. If the 'job' option is applied to a Job Schedule, the Batch
        /// service creates a new auto Pool for every Job created on the
        /// schedule.
        /// </summary>
        [EnumMember(Value = "job")]
        Job
    }
    internal static class PoolLifetimeOptionEnumExtension
    {
        internal static string ToSerializedValue(this PoolLifetimeOption? value)
        {
            return value == null ? null : ((PoolLifetimeOption)value).ToSerializedValue();
        }

        internal static string ToSerializedValue(this PoolLifetimeOption value)
        {
            switch( value )
            {
                case PoolLifetimeOption.JobSchedule:
                    return "jobschedule";
                case PoolLifetimeOption.Job:
                    return "job";
            }
            return null;
        }

        internal static PoolLifetimeOption? ParsePoolLifetimeOption(this string value)
        {
            switch( value )
            {
                case "jobschedule":
                    return PoolLifetimeOption.JobSchedule;
                case "job":
                    return PoolLifetimeOption.Job;
            }
            return null;
        }
    }
}
