// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// Specifies how a Job should be assigned to a Pool.
    /// </summary>
    public partial class PoolInformation
    {
        /// <summary>
        /// Initializes a new instance of the PoolInformation class.
        /// </summary>
        public PoolInformation()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the PoolInformation class.
        /// </summary>
        /// <param name="poolId">The ID of an existing Pool. All the Tasks of
        /// the Job will run on the specified Pool.</param>
        /// <param name="autoPoolSpecification">Characteristics for a temporary
        /// 'auto pool'. The Batch service will create this auto Pool when the
        /// Job is submitted.</param>
        public PoolInformation(string poolId = default(string), AutoPoolSpecification autoPoolSpecification = default(AutoPoolSpecification))
        {
            PoolId = poolId;
            AutoPoolSpecification = autoPoolSpecification;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the ID of an existing Pool. All the Tasks of the Job
        /// will run on the specified Pool.
        /// </summary>
        /// <remarks>
        /// You must ensure that the Pool referenced by this property exists.
        /// If the Pool does not exist at the time the Batch service tries to
        /// schedule a Job, no Tasks for the Job will run until you create a
        /// Pool with that id. Note that the Batch service will not reject the
        /// Job request; it will simply not run Tasks until the Pool exists.
        /// You must specify either the Pool ID or the auto Pool specification,
        /// but not both.
        /// </remarks>
        [JsonProperty(PropertyName = "poolId")]
        public string PoolId { get; set; }

        /// <summary>
        /// Gets or sets characteristics for a temporary 'auto pool'. The Batch
        /// service will create this auto Pool when the Job is submitted.
        /// </summary>
        /// <remarks>
        /// If auto Pool creation fails, the Batch service moves the Job to a
        /// completed state, and the Pool creation error is set in the Job's
        /// scheduling error property. The Batch service manages the lifetime
        /// (both creation and, unless keepAlive is specified, deletion) of the
        /// auto Pool. Any user actions that affect the lifetime of the auto
        /// Pool while the Job is active will result in unexpected behavior.
        /// You must specify either the Pool ID or the auto Pool specification,
        /// but not both.
        /// </remarks>
        [JsonProperty(PropertyName = "autoPoolSpecification")]
        public AutoPoolSpecification AutoPoolSpecification { get; set; }

    }
}
