// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using Newtonsoft.Json.Converters;
    using System.Runtime;
    using System.Runtime.Serialization;

    /// <summary>
    /// Defines values for PoolIdentityType.
    /// </summary>
    [JsonConverter(typeof(StringEnumConverter))]
    public enum PoolIdentityType
    {
        /// <summary>
        /// Batch pool has user assigned identities with it.
        /// </summary>
        [EnumMember(Value = "UserAssigned")]
        UserAssigned,
        /// <summary>
        /// Batch pool has no identity associated with it. Setting `None` in
        /// update pool will remove existing identities.
        /// </summary>
        [EnumMember(Value = "None")]
        None
    }
    internal static class PoolIdentityTypeEnumExtension
    {
        internal static string ToSerializedValue(this PoolIdentityType? value)
        {
            return value == null ? null : ((PoolIdentityType)value).ToSerializedValue();
        }

        internal static string ToSerializedValue(this PoolIdentityType value)
        {
            switch( value )
            {
                case PoolIdentityType.UserAssigned:
                    return "UserAssigned";
                case PoolIdentityType.None:
                    return "None";
            }
            return null;
        }

        internal static PoolIdentityType? ParsePoolIdentityType(this string value)
        {
            switch( value )
            {
                case "UserAssigned":
                    return PoolIdentityType.UserAssigned;
                case "None":
                    return PoolIdentityType.None;
            }
            return null;
        }
    }
}
