// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using Newtonsoft.Json.Converters;
    using System.Runtime;
    using System.Runtime.Serialization;

    /// <summary>
    /// Defines values for OutputFileUploadCondition.
    /// </summary>
    [JsonConverter(typeof(StringEnumConverter))]
    public enum OutputFileUploadCondition
    {
        /// <summary>
        /// Upload the file(s) only after the Task process exits with an exit
        /// code of 0.
        /// </summary>
        [EnumMember(Value = "tasksuccess")]
        TaskSuccess,
        /// <summary>
        /// Upload the file(s) only after the Task process exits with a nonzero
        /// exit code.
        /// </summary>
        [EnumMember(Value = "taskfailure")]
        TaskFailure,
        /// <summary>
        /// Upload the file(s) after the Task process exits, no matter what the
        /// exit code was.
        /// </summary>
        [EnumMember(Value = "taskcompletion")]
        TaskCompletion
    }
    internal static class OutputFileUploadConditionEnumExtension
    {
        internal static string ToSerializedValue(this OutputFileUploadCondition? value)
        {
            return value == null ? null : ((OutputFileUploadCondition)value).ToSerializedValue();
        }

        internal static string ToSerializedValue(this OutputFileUploadCondition value)
        {
            switch( value )
            {
                case OutputFileUploadCondition.TaskSuccess:
                    return "tasksuccess";
                case OutputFileUploadCondition.TaskFailure:
                    return "taskfailure";
                case OutputFileUploadCondition.TaskCompletion:
                    return "taskcompletion";
            }
            return null;
        }

        internal static OutputFileUploadCondition? ParseOutputFileUploadCondition(this string value)
        {
            switch( value )
            {
                case "tasksuccess":
                    return OutputFileUploadCondition.TaskSuccess;
                case "taskfailure":
                    return OutputFileUploadCondition.TaskFailure;
                case "taskcompletion":
                    return OutputFileUploadCondition.TaskCompletion;
            }
            return null;
        }
    }
}
