// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Specifies a file upload destination within an Azure blob storage
    /// container.
    /// </summary>
    public partial class OutputFileBlobContainerDestination
    {
        /// <summary>
        /// Initializes a new instance of the
        /// OutputFileBlobContainerDestination class.
        /// </summary>
        public OutputFileBlobContainerDestination()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the
        /// OutputFileBlobContainerDestination class.
        /// </summary>
        /// <param name="containerUrl">The URL of the container within Azure
        /// Blob Storage to which to upload the file(s).</param>
        /// <param name="path">The destination blob or virtual directory within
        /// the Azure Storage container.</param>
        /// <param name="identityReference">The reference to the user assigned
        /// identity to use to access Azure Blob Storage specified by
        /// containerUrl</param>
        /// <param name="uploadHeaders">A list of name-value pairs for headers
        /// to be used in uploading output files</param>
        public OutputFileBlobContainerDestination(string containerUrl, string path = default(string), ComputeNodeIdentityReference identityReference = default(ComputeNodeIdentityReference), IList<HttpHeader> uploadHeaders = default(IList<HttpHeader>))
        {
            Path = path;
            ContainerUrl = containerUrl;
            IdentityReference = identityReference;
            UploadHeaders = uploadHeaders;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the destination blob or virtual directory within the
        /// Azure Storage container.
        /// </summary>
        /// <remarks>
        /// If filePattern refers to a specific file (i.e. contains no
        /// wildcards), then path is the name of the blob to which to upload
        /// that file. If filePattern contains one or more wildcards (and
        /// therefore may match multiple files), then path is the name of the
        /// blob virtual directory (which is prepended to each blob name) to
        /// which to upload the file(s). If omitted, file(s) are uploaded to
        /// the root of the container with a blob name matching their file
        /// name.
        /// </remarks>
        [JsonProperty(PropertyName = "path")]
        public string Path { get; set; }

        /// <summary>
        /// Gets or sets the URL of the container within Azure Blob Storage to
        /// which to upload the file(s).
        /// </summary>
        /// <remarks>
        /// If not using a managed identity, the URL must include a Shared
        /// Access Signature (SAS) granting write permissions to the container.
        /// </remarks>
        [JsonProperty(PropertyName = "containerUrl")]
        public string ContainerUrl { get; set; }

        /// <summary>
        /// Gets or sets the reference to the user assigned identity to use to
        /// access Azure Blob Storage specified by containerUrl
        /// </summary>
        /// <remarks>
        /// The identity must have write access to the Azure Blob Storage
        /// container
        /// </remarks>
        [JsonProperty(PropertyName = "identityReference")]
        public ComputeNodeIdentityReference IdentityReference { get; set; }

        /// <summary>
        /// Gets or sets a list of name-value pairs for headers to be used in
        /// uploading output files
        /// </summary>
        /// <remarks>
        /// These headers will be specified when uploading files to Azure
        /// Storage. Official document on allowed headers when uploading blobs:
        /// https://docs.microsoft.com/rest/api/storageservices/put-blob#request-headers-all-blob-types
        /// </remarks>
        [JsonProperty(PropertyName = "uploadHeaders")]
        public IList<HttpHeader> UploadHeaders { get; set; }

    }
}
