// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// A specification for uploading files from an Azure Batch Compute Node to
    /// another location after the Batch service has finished executing the
    /// Task process.
    /// </summary>
    /// <remarks>
    /// On every file uploads, Batch service writes two log files to the
    /// compute node, 'fileuploadout.txt' and 'fileuploaderr.txt'. These log
    /// files are used to learn more about a specific failure.
    /// </remarks>
    public partial class OutputFile
    {
        /// <summary>
        /// Initializes a new instance of the OutputFile class.
        /// </summary>
        public OutputFile()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the OutputFile class.
        /// </summary>
        /// <param name="filePattern">A pattern indicating which file(s) to
        /// upload.</param>
        /// <param name="destination">The destination for the output
        /// file(s).</param>
        /// <param name="uploadOptions">Additional options for the upload
        /// operation, including under what conditions to perform the
        /// upload.</param>
        public OutputFile(string filePattern, OutputFileDestination destination, OutputFileUploadOptions uploadOptions)
        {
            FilePattern = filePattern;
            Destination = destination;
            UploadOptions = uploadOptions;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets a pattern indicating which file(s) to upload.
        /// </summary>
        /// <remarks>
        /// Both relative and absolute paths are supported. Relative paths are
        /// relative to the Task working directory. The following wildcards are
        /// supported: * matches 0 or more characters (for example pattern abc*
        /// would match abc or abcdef), ** matches any directory, ? matches any
        /// single character, [abc] matches one character in the brackets, and
        /// [a-c] matches one character in the range. Brackets can include a
        /// negation to match any character not specified (for example [!abc]
        /// matches any character but a, b, or c). If a file name starts with
        /// "." it is ignored by default but may be matched by specifying it
        /// explicitly (for example *.gif will not match .a.gif, but .*.gif
        /// will). A simple example: **\*.txt matches any file that does not
        /// start in '.' and ends with .txt in the Task working directory or
        /// any subdirectory. If the filename contains a wildcard character it
        /// can be escaped using brackets (for example abc[*] would match a
        /// file named abc*). Note that both \ and / are treated as directory
        /// separators on Windows, but only / is on Linux. Environment
        /// variables (%var% on Windows or $var on Linux) are expanded prior to
        /// the pattern being applied.
        /// </remarks>
        [JsonProperty(PropertyName = "filePattern")]
        public string FilePattern { get; set; }

        /// <summary>
        /// Gets or sets the destination for the output file(s).
        /// </summary>
        [JsonProperty(PropertyName = "destination")]
        public OutputFileDestination Destination { get; set; }

        /// <summary>
        /// Gets or sets additional options for the upload operation, including
        /// under what conditions to perform the upload.
        /// </summary>
        [JsonProperty(PropertyName = "uploadOptions")]
        public OutputFileUploadOptions UploadOptions { get; set; }

    }
}
