// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// The set of changes to be made to a user Account on a Compute Node.
    /// </summary>
    public partial class NodeUpdateUserParameter
    {
        /// <summary>
        /// Initializes a new instance of the NodeUpdateUserParameter class.
        /// </summary>
        public NodeUpdateUserParameter()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the NodeUpdateUserParameter class.
        /// </summary>
        /// <param name="password">The password of the Account.</param>
        /// <param name="expiryTime">The time at which the Account should
        /// expire.</param>
        /// <param name="sshPublicKey">The SSH public key that can be used for
        /// remote login to the Compute Node.</param>
        public NodeUpdateUserParameter(string password = default(string), System.DateTime? expiryTime = default(System.DateTime?), string sshPublicKey = default(string))
        {
            Password = password;
            ExpiryTime = expiryTime;
            SshPublicKey = sshPublicKey;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the password of the Account.
        /// </summary>
        /// <remarks>
        /// The password is required for Windows Compute Nodes. For Linux
        /// Compute Nodes, the password can optionally be specified along with
        /// the sshPublicKey property. If omitted, any existing password is
        /// removed.
        /// </remarks>
        [JsonProperty(PropertyName = "password")]
        public string Password { get; set; }

        /// <summary>
        /// Gets or sets the time at which the Account should expire.
        /// </summary>
        /// <remarks>
        /// If omitted, the default is 1 day from the current time. For Linux
        /// Compute Nodes, the expiryTime has a precision up to a day.
        /// </remarks>
        [JsonProperty(PropertyName = "expiryTime")]
        public System.DateTime? ExpiryTime { get; set; }

        /// <summary>
        /// Gets or sets the SSH public key that can be used for remote login
        /// to the Compute Node.
        /// </summary>
        /// <remarks>
        /// The public key should be compatible with OpenSSH encoding and
        /// should be base 64 encoded. This property can be specified only for
        /// Linux Compute Nodes. If this is specified for a Windows Compute
        /// Node, then the Batch service rejects the request; if you are
        /// calling the REST API directly, the HTTP status code is 400 (Bad
        /// Request). If omitted, any existing SSH public key is removed.
        /// </remarks>
        [JsonProperty(PropertyName = "sshPublicKey")]
        public string SshPublicKey { get; set; }

    }
}
