// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using Newtonsoft.Json.Converters;
    using System.Runtime;
    using System.Runtime.Serialization;

    /// <summary>
    /// Defines values for NodeCommunicationMode.
    /// </summary>
    [JsonConverter(typeof(StringEnumConverter))]
    public enum NodeCommunicationMode
    {
        /// <summary>
        /// The node communication mode is automatically set by the Batch
        /// service.
        /// </summary>
        [EnumMember(Value = "default")]
        Default,
        /// <summary>
        /// Nodes using the classic communication mode require inbound TCP
        /// communication on ports 29876 and 29877 from the
        /// "BatchNodeManagement.{region}" service tag and outbound TCP
        /// communication on port 443 to the "Storage.region" and
        /// "BatchNodeManagement.{region}" service tags.
        /// </summary>
        [EnumMember(Value = "classic")]
        Classic,
        /// <summary>
        /// Nodes using the simplified communication mode require outbound TCP
        /// communication on port 443 to the "BatchNodeManagement.{region}"
        /// service tag. No open inbound ports are required.
        /// </summary>
        [EnumMember(Value = "simplified")]
        Simplified
    }
    internal static class NodeCommunicationModeEnumExtension
    {
        internal static string ToSerializedValue(this NodeCommunicationMode? value)
        {
            return value == null ? null : ((NodeCommunicationMode)value).ToSerializedValue();
        }

        internal static string ToSerializedValue(this NodeCommunicationMode value)
        {
            switch( value )
            {
                case NodeCommunicationMode.Default:
                    return "default";
                case NodeCommunicationMode.Classic:
                    return "classic";
                case NodeCommunicationMode.Simplified:
                    return "simplified";
            }
            return null;
        }

        internal static NodeCommunicationMode? ParseNodeCommunicationMode(this string value)
        {
            switch( value )
            {
                case "default":
                    return NodeCommunicationMode.Default;
                case "classic":
                    return NodeCommunicationMode.Classic;
                case "simplified":
                    return NodeCommunicationMode.Simplified;
            }
            return null;
        }
    }
}
