// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Settings which specify how to run a multi-instance Task.
    /// </summary>
    /// <remarks>
    /// Multi-instance Tasks are commonly used to support MPI Tasks. In the MPI
    /// case, if any of the subtasks fail (for example due to exiting with a
    /// non-zero exit code) the entire multi-instance Task fails. The
    /// multi-instance Task is then terminated and retried, up to its retry
    /// limit.
    /// </remarks>
    public partial class MultiInstanceSettings
    {
        /// <summary>
        /// Initializes a new instance of the MultiInstanceSettings class.
        /// </summary>
        public MultiInstanceSettings()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the MultiInstanceSettings class.
        /// </summary>
        /// <param name="coordinationCommandLine">The command line to run on
        /// all the Compute Nodes to enable them to coordinate when the primary
        /// runs the main Task command.</param>
        /// <param name="numberOfInstances">The number of Compute Nodes
        /// required by the Task.</param>
        /// <param name="commonResourceFiles">A list of files that the Batch
        /// service will download before running the coordination command
        /// line.</param>
        public MultiInstanceSettings(string coordinationCommandLine, int? numberOfInstances = default(int?), IList<ResourceFile> commonResourceFiles = default(IList<ResourceFile>))
        {
            NumberOfInstances = numberOfInstances;
            CoordinationCommandLine = coordinationCommandLine;
            CommonResourceFiles = commonResourceFiles;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the number of Compute Nodes required by the Task.
        /// </summary>
        /// <remarks>
        /// If omitted, the default is 1.
        /// </remarks>
        [JsonProperty(PropertyName = "numberOfInstances")]
        public int? NumberOfInstances { get; set; }

        /// <summary>
        /// Gets or sets the command line to run on all the Compute Nodes to
        /// enable them to coordinate when the primary runs the main Task
        /// command.
        /// </summary>
        /// <remarks>
        /// A typical coordination command line launches a background service
        /// and verifies that the service is ready to process inter-node
        /// messages.
        /// </remarks>
        [JsonProperty(PropertyName = "coordinationCommandLine")]
        public string CoordinationCommandLine { get; set; }

        /// <summary>
        /// Gets or sets a list of files that the Batch service will download
        /// before running the coordination command line.
        /// </summary>
        /// <remarks>
        /// The difference between common resource files and Task resource
        /// files is that common resource files are downloaded for all subtasks
        /// including the primary, whereas Task resource files are downloaded
        /// only for the primary. Also note that these resource files are not
        /// downloaded to the Task working directory, but instead are
        /// downloaded to the Task root directory (one directory above the
        /// working directory).  There is a maximum size for the list of
        /// resource files.  When the max size is exceeded, the request will
        /// fail and the response error code will be RequestEntityTooLarge. If
        /// this occurs, the collection of ResourceFiles must be reduced in
        /// size. This can be achieved using .zip files, Application Packages,
        /// or Docker Containers.
        /// </remarks>
        [JsonProperty(PropertyName = "commonResourceFiles")]
        public IList<ResourceFile> CommonResourceFiles { get; set; }

    }
}
