// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// The file system to mount on each node.
    /// </summary>
    public partial class MountConfiguration
    {
        /// <summary>
        /// Initializes a new instance of the MountConfiguration class.
        /// </summary>
        public MountConfiguration()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the MountConfiguration class.
        /// </summary>
        /// <param name="azureBlobFileSystemConfiguration">The Azure Storage
        /// Container to mount using blob FUSE on each node.</param>
        /// <param name="nfsMountConfiguration">The NFS file system to mount on
        /// each node.</param>
        /// <param name="cifsMountConfiguration">The CIFS/SMB file system to
        /// mount on each node.</param>
        /// <param name="azureFileShareConfiguration">The Azure File Share to
        /// mount on each node.</param>
        public MountConfiguration(AzureBlobFileSystemConfiguration azureBlobFileSystemConfiguration = default(AzureBlobFileSystemConfiguration), NFSMountConfiguration nfsMountConfiguration = default(NFSMountConfiguration), CIFSMountConfiguration cifsMountConfiguration = default(CIFSMountConfiguration), AzureFileShareConfiguration azureFileShareConfiguration = default(AzureFileShareConfiguration))
        {
            AzureBlobFileSystemConfiguration = azureBlobFileSystemConfiguration;
            NfsMountConfiguration = nfsMountConfiguration;
            CifsMountConfiguration = cifsMountConfiguration;
            AzureFileShareConfiguration = azureFileShareConfiguration;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the Azure Storage Container to mount using blob FUSE
        /// on each node.
        /// </summary>
        /// <remarks>
        /// This property is mutually exclusive with all other properties.
        /// </remarks>
        [JsonProperty(PropertyName = "azureBlobFileSystemConfiguration")]
        public AzureBlobFileSystemConfiguration AzureBlobFileSystemConfiguration { get; set; }

        /// <summary>
        /// Gets or sets the NFS file system to mount on each node.
        /// </summary>
        /// <remarks>
        /// This property is mutually exclusive with all other properties.
        /// </remarks>
        [JsonProperty(PropertyName = "nfsMountConfiguration")]
        public NFSMountConfiguration NfsMountConfiguration { get; set; }

        /// <summary>
        /// Gets or sets the CIFS/SMB file system to mount on each node.
        /// </summary>
        /// <remarks>
        /// This property is mutually exclusive with all other properties.
        /// </remarks>
        [JsonProperty(PropertyName = "cifsMountConfiguration")]
        public CIFSMountConfiguration CifsMountConfiguration { get; set; }

        /// <summary>
        /// Gets or sets the Azure File Share to mount on each node.
        /// </summary>
        /// <remarks>
        /// This property is mutually exclusive with all other properties.
        /// </remarks>
        [JsonProperty(PropertyName = "azureFileShareConfiguration")]
        public AzureFileShareConfiguration AzureFileShareConfiguration { get; set; }

    }
}
