// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// Resource usage statistics for a Job.
    /// </summary>
    public partial class JobStatistics
    {
        /// <summary>
        /// Initializes a new instance of the JobStatistics class.
        /// </summary>
        public JobStatistics()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the JobStatistics class.
        /// </summary>
        /// <param name="url">The URL of the statistics.</param>
        /// <param name="startTime">The start time of the time range covered by
        /// the statistics.</param>
        /// <param name="lastUpdateTime">The time at which the statistics were
        /// last updated. All statistics are limited to the range between
        /// startTime and lastUpdateTime.</param>
        /// <param name="userCPUTime">The total user mode CPU time (summed
        /// across all cores and all Compute Nodes) consumed by all Tasks in
        /// the Job.</param>
        /// <param name="kernelCPUTime">The total kernel mode CPU time (summed
        /// across all cores and all Compute Nodes) consumed by all Tasks in
        /// the Job.</param>
        /// <param name="wallClockTime">The total wall clock time of all Tasks
        /// in the Job.</param>
        /// <param name="readIOps">The total number of disk read operations
        /// made by all Tasks in the Job.</param>
        /// <param name="writeIOps">The total number of disk write operations
        /// made by all Tasks in the Job.</param>
        /// <param name="readIOGiB">The total amount of data in GiB read from
        /// disk by all Tasks in the Job.</param>
        /// <param name="writeIOGiB">The total amount of data in GiB written to
        /// disk by all Tasks in the Job.</param>
        /// <param name="numSucceededTasks">The total number of Tasks
        /// successfully completed in the Job during the given time
        /// range.</param>
        /// <param name="numFailedTasks">The total number of Tasks in the Job
        /// that failed during the given time range.</param>
        /// <param name="numTaskRetries">The total number of retries on all the
        /// Tasks in the Job during the given time range.</param>
        /// <param name="waitTime">The total wait time of all Tasks in the
        /// Job.</param>
        public JobStatistics(string url, System.DateTime startTime, System.DateTime lastUpdateTime, System.TimeSpan userCPUTime, System.TimeSpan kernelCPUTime, System.TimeSpan wallClockTime, long readIOps, long writeIOps, double readIOGiB, double writeIOGiB, long numSucceededTasks, long numFailedTasks, long numTaskRetries, System.TimeSpan waitTime)
        {
            Url = url;
            StartTime = startTime;
            LastUpdateTime = lastUpdateTime;
            UserCPUTime = userCPUTime;
            KernelCPUTime = kernelCPUTime;
            WallClockTime = wallClockTime;
            ReadIOps = readIOps;
            WriteIOps = writeIOps;
            ReadIOGiB = readIOGiB;
            WriteIOGiB = writeIOGiB;
            NumSucceededTasks = numSucceededTasks;
            NumFailedTasks = numFailedTasks;
            NumTaskRetries = numTaskRetries;
            WaitTime = waitTime;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the URL of the statistics.
        /// </summary>
        [JsonProperty(PropertyName = "url")]
        public string Url { get; set; }

        /// <summary>
        /// Gets or sets the start time of the time range covered by the
        /// statistics.
        /// </summary>
        [JsonProperty(PropertyName = "startTime")]
        public System.DateTime StartTime { get; set; }

        /// <summary>
        /// Gets or sets the time at which the statistics were last updated.
        /// All statistics are limited to the range between startTime and
        /// lastUpdateTime.
        /// </summary>
        [JsonProperty(PropertyName = "lastUpdateTime")]
        public System.DateTime LastUpdateTime { get; set; }

        /// <summary>
        /// Gets or sets the total user mode CPU time (summed across all cores
        /// and all Compute Nodes) consumed by all Tasks in the Job.
        /// </summary>
        [JsonProperty(PropertyName = "userCPUTime")]
        public System.TimeSpan UserCPUTime { get; set; }

        /// <summary>
        /// Gets or sets the total kernel mode CPU time (summed across all
        /// cores and all Compute Nodes) consumed by all Tasks in the Job.
        /// </summary>
        [JsonProperty(PropertyName = "kernelCPUTime")]
        public System.TimeSpan KernelCPUTime { get; set; }

        /// <summary>
        /// Gets or sets the total wall clock time of all Tasks in the Job.
        /// </summary>
        /// <remarks>
        /// The wall clock time is the elapsed time from when the Task started
        /// running on a Compute Node to when it finished (or to the last time
        /// the statistics were updated, if the Task had not finished by then).
        /// If a Task was retried, this includes the wall clock time of all the
        /// Task retries.
        /// </remarks>
        [JsonProperty(PropertyName = "wallClockTime")]
        public System.TimeSpan WallClockTime { get; set; }

        /// <summary>
        /// Gets or sets the total number of disk read operations made by all
        /// Tasks in the Job.
        /// </summary>
        [JsonProperty(PropertyName = "readIOps")]
        public long ReadIOps { get; set; }

        /// <summary>
        /// Gets or sets the total number of disk write operations made by all
        /// Tasks in the Job.
        /// </summary>
        [JsonProperty(PropertyName = "writeIOps")]
        public long WriteIOps { get; set; }

        /// <summary>
        /// Gets or sets the total amount of data in GiB read from disk by all
        /// Tasks in the Job.
        /// </summary>
        [JsonProperty(PropertyName = "readIOGiB")]
        public double ReadIOGiB { get; set; }

        /// <summary>
        /// Gets or sets the total amount of data in GiB written to disk by all
        /// Tasks in the Job.
        /// </summary>
        [JsonProperty(PropertyName = "writeIOGiB")]
        public double WriteIOGiB { get; set; }

        /// <summary>
        /// Gets or sets the total number of Tasks successfully completed in
        /// the Job during the given time range.
        /// </summary>
        /// <remarks>
        /// A Task completes successfully if it returns exit code 0.
        /// </remarks>
        [JsonProperty(PropertyName = "numSucceededTasks")]
        public long NumSucceededTasks { get; set; }

        /// <summary>
        /// Gets or sets the total number of Tasks in the Job that failed
        /// during the given time range.
        /// </summary>
        /// <remarks>
        /// A Task fails if it exhausts its maximum retry count without
        /// returning exit code 0.
        /// </remarks>
        [JsonProperty(PropertyName = "numFailedTasks")]
        public long NumFailedTasks { get; set; }

        /// <summary>
        /// Gets or sets the total number of retries on all the Tasks in the
        /// Job during the given time range.
        /// </summary>
        [JsonProperty(PropertyName = "numTaskRetries")]
        public long NumTaskRetries { get; set; }

        /// <summary>
        /// Gets or sets the total wait time of all Tasks in the Job.
        /// </summary>
        /// <remarks>
        /// The wait time for a Task is defined as the elapsed time between the
        /// creation of the Task and the start of Task execution. (If the Task
        /// is retried due to failures, the wait time is the time to the most
        /// recent Task execution.) This value is only reported in the Account
        /// lifetime statistics; it is not included in the Job statistics.
        /// </remarks>
        [JsonProperty(PropertyName = "waitTime")]
        public System.TimeSpan WaitTime { get; set; }

    }
}
