// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Specifies details of the Jobs to be created on a schedule.
    /// </summary>
    public partial class JobSpecification
    {
        /// <summary>
        /// Initializes a new instance of the JobSpecification class.
        /// </summary>
        public JobSpecification()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the JobSpecification class.
        /// </summary>
        /// <param name="poolInfo">The Pool on which the Batch service runs the
        /// Tasks of Jobs created under this schedule.</param>
        /// <param name="priority">The priority of Jobs created under this
        /// schedule.</param>
        /// <param name="allowTaskPreemption">Whether Tasks in this job can be
        /// preempted by other high priority jobs</param>
        /// <param name="maxParallelTasks">The maximum number of tasks that can
        /// be executed in parallel for the job.</param>
        /// <param name="displayName">The display name for Jobs created under
        /// this schedule.</param>
        /// <param name="usesTaskDependencies">Whether Tasks in the Job can
        /// define dependencies on each other. The default is false.</param>
        /// <param name="onAllTasksComplete">The action the Batch service
        /// should take when all Tasks in a Job created under this schedule are
        /// in the completed state.</param>
        /// <param name="onTaskFailure">The action the Batch service should
        /// take when any Task fails in a Job created under this schedule. A
        /// Task is considered to have failed if it have failed if has a
        /// failureInfo. A failureInfo is set if the Task completes with a
        /// non-zero exit code after exhausting its retry count, or if there
        /// was an error starting the Task, for example due to a resource file
        /// download error.</param>
        /// <param name="networkConfiguration">The network configuration for
        /// the Job.</param>
        /// <param name="constraints">The execution constraints for Jobs
        /// created under this schedule.</param>
        /// <param name="jobManagerTask">The details of a Job Manager Task to
        /// be launched when a Job is started under this schedule.</param>
        /// <param name="jobPreparationTask">The Job Preparation Task for Jobs
        /// created under this schedule.</param>
        /// <param name="jobReleaseTask">The Job Release Task for Jobs created
        /// under this schedule.</param>
        /// <param name="commonEnvironmentSettings">A list of common
        /// environment variable settings. These environment variables are set
        /// for all Tasks in Jobs created under this schedule (including the
        /// Job Manager, Job Preparation and Job Release Tasks).</param>
        /// <param name="metadata">A list of name-value pairs associated with
        /// each Job created under this schedule as metadata.</param>
        public JobSpecification(PoolInformation poolInfo, int? priority = default(int?), bool? allowTaskPreemption = default(bool?), int? maxParallelTasks = default(int?), string displayName = default(string), bool? usesTaskDependencies = default(bool?), OnAllTasksComplete? onAllTasksComplete = default(OnAllTasksComplete?), OnTaskFailure? onTaskFailure = default(OnTaskFailure?), JobNetworkConfiguration networkConfiguration = default(JobNetworkConfiguration), JobConstraints constraints = default(JobConstraints), JobManagerTask jobManagerTask = default(JobManagerTask), JobPreparationTask jobPreparationTask = default(JobPreparationTask), JobReleaseTask jobReleaseTask = default(JobReleaseTask), IList<EnvironmentSetting> commonEnvironmentSettings = default(IList<EnvironmentSetting>), IList<MetadataItem> metadata = default(IList<MetadataItem>))
        {
            Priority = priority;
            AllowTaskPreemption = allowTaskPreemption;
            MaxParallelTasks = maxParallelTasks;
            DisplayName = displayName;
            UsesTaskDependencies = usesTaskDependencies;
            OnAllTasksComplete = onAllTasksComplete;
            OnTaskFailure = onTaskFailure;
            NetworkConfiguration = networkConfiguration;
            Constraints = constraints;
            JobManagerTask = jobManagerTask;
            JobPreparationTask = jobPreparationTask;
            JobReleaseTask = jobReleaseTask;
            CommonEnvironmentSettings = commonEnvironmentSettings;
            PoolInfo = poolInfo;
            Metadata = metadata;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the priority of Jobs created under this schedule.
        /// </summary>
        /// <remarks>
        /// Priority values can range from -1000 to 1000, with -1000 being the
        /// lowest priority and 1000 being the highest priority. The default
        /// value is 0. This priority is used as the default for all Jobs under
        /// the Job Schedule. You can update a Job's priority after it has been
        /// created using by using the update Job API.
        /// </remarks>
        [JsonProperty(PropertyName = "priority")]
        public int? Priority { get; set; }

        /// <summary>
        /// Gets or sets whether Tasks in this job can be preempted by other
        /// high priority jobs
        /// </summary>
        /// <remarks>
        /// If the value is set to True, other high priority jobs submitted to
        /// the system will take precedence and will be able requeue tasks from
        /// this job. You can update a job's allowTaskPreemption after it has
        /// been created using the update job API.
        /// </remarks>
        [JsonProperty(PropertyName = "allowTaskPreemption")]
        public bool? AllowTaskPreemption { get; set; }

        /// <summary>
        /// Gets or sets the maximum number of tasks that can be executed in
        /// parallel for the job.
        /// </summary>
        /// <remarks>
        /// The value of maxParallelTasks must be -1 or greater than 0 if
        /// specified. If not specified, the default value is -1, which means
        /// there's no limit to the number of tasks that can be run at once.
        /// You can update a job's maxParallelTasks after it has been created
        /// using the update job API.
        /// </remarks>
        [JsonProperty(PropertyName = "maxParallelTasks")]
        public int? MaxParallelTasks { get; set; }

        /// <summary>
        /// Gets or sets the display name for Jobs created under this schedule.
        /// </summary>
        /// <remarks>
        /// The name need not be unique and can contain any Unicode characters
        /// up to a maximum length of 1024.
        /// </remarks>
        [JsonProperty(PropertyName = "displayName")]
        public string DisplayName { get; set; }

        /// <summary>
        /// Gets or sets whether Tasks in the Job can define dependencies on
        /// each other. The default is false.
        /// </summary>
        [JsonProperty(PropertyName = "usesTaskDependencies")]
        public bool? UsesTaskDependencies { get; set; }

        /// <summary>
        /// Gets or sets the action the Batch service should take when all
        /// Tasks in a Job created under this schedule are in the completed
        /// state.
        /// </summary>
        /// <remarks>
        /// Note that if a Job contains no Tasks, then all Tasks are considered
        /// complete. This option is therefore most commonly used with a Job
        /// Manager task; if you want to use automatic Job termination without
        /// a Job Manager, you should initially set onAllTasksComplete to
        /// noaction and update the Job properties to set onAllTasksComplete to
        /// terminatejob once you have finished adding Tasks. The default is
        /// noaction. Possible values include: 'noAction', 'terminateJob'
        /// </remarks>
        [JsonProperty(PropertyName = "onAllTasksComplete")]
        public OnAllTasksComplete? OnAllTasksComplete { get; set; }

        /// <summary>
        /// Gets or sets the action the Batch service should take when any Task
        /// fails in a Job created under this schedule. A Task is considered to
        /// have failed if it have failed if has a failureInfo. A failureInfo
        /// is set if the Task completes with a non-zero exit code after
        /// exhausting its retry count, or if there was an error starting the
        /// Task, for example due to a resource file download error.
        /// </summary>
        /// <remarks>
        /// The default is noaction. Possible values include: 'noAction',
        /// 'performExitOptionsJobAction'
        /// </remarks>
        [JsonProperty(PropertyName = "onTaskFailure")]
        public OnTaskFailure? OnTaskFailure { get; set; }

        /// <summary>
        /// Gets or sets the network configuration for the Job.
        /// </summary>
        [JsonProperty(PropertyName = "networkConfiguration")]
        public JobNetworkConfiguration NetworkConfiguration { get; set; }

        /// <summary>
        /// Gets or sets the execution constraints for Jobs created under this
        /// schedule.
        /// </summary>
        [JsonProperty(PropertyName = "constraints")]
        public JobConstraints Constraints { get; set; }

        /// <summary>
        /// Gets or sets the details of a Job Manager Task to be launched when
        /// a Job is started under this schedule.
        /// </summary>
        /// <remarks>
        /// If the Job does not specify a Job Manager Task, the user must
        /// explicitly add Tasks to the Job using the Task API. If the Job does
        /// specify a Job Manager Task, the Batch service creates the Job
        /// Manager Task when the Job is created, and will try to schedule the
        /// Job Manager Task before scheduling other Tasks in the Job.
        /// </remarks>
        [JsonProperty(PropertyName = "jobManagerTask")]
        public JobManagerTask JobManagerTask { get; set; }

        /// <summary>
        /// Gets or sets the Job Preparation Task for Jobs created under this
        /// schedule.
        /// </summary>
        /// <remarks>
        /// If a Job has a Job Preparation Task, the Batch service will run the
        /// Job Preparation Task on a Node before starting any Tasks of that
        /// Job on that Compute Node.
        /// </remarks>
        [JsonProperty(PropertyName = "jobPreparationTask")]
        public JobPreparationTask JobPreparationTask { get; set; }

        /// <summary>
        /// Gets or sets the Job Release Task for Jobs created under this
        /// schedule.
        /// </summary>
        /// <remarks>
        /// The primary purpose of the Job Release Task is to undo changes to
        /// Nodes made by the Job Preparation Task. Example activities include
        /// deleting local files, or shutting down services that were started
        /// as part of Job preparation. A Job Release Task cannot be specified
        /// without also specifying a Job Preparation Task for the Job. The
        /// Batch service runs the Job Release Task on the Compute Nodes that
        /// have run the Job Preparation Task.
        /// </remarks>
        [JsonProperty(PropertyName = "jobReleaseTask")]
        public JobReleaseTask JobReleaseTask { get; set; }

        /// <summary>
        /// Gets or sets a list of common environment variable settings. These
        /// environment variables are set for all Tasks in Jobs created under
        /// this schedule (including the Job Manager, Job Preparation and Job
        /// Release Tasks).
        /// </summary>
        /// <remarks>
        /// Individual Tasks can override an environment setting specified here
        /// by specifying the same setting name with a different value.
        /// </remarks>
        [JsonProperty(PropertyName = "commonEnvironmentSettings")]
        public IList<EnvironmentSetting> CommonEnvironmentSettings { get; set; }

        /// <summary>
        /// Gets or sets the Pool on which the Batch service runs the Tasks of
        /// Jobs created under this schedule.
        /// </summary>
        [JsonProperty(PropertyName = "poolInfo")]
        public PoolInformation PoolInfo { get; set; }

        /// <summary>
        /// Gets or sets a list of name-value pairs associated with each Job
        /// created under this schedule as metadata.
        /// </summary>
        /// <remarks>
        /// The Batch service does not assign any meaning to metadata; it is
        /// solely for the use of user code.
        /// </remarks>
        [JsonProperty(PropertyName = "metadata")]
        public IList<MetadataItem> Metadata { get; set; }

    }
}
