// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using Newtonsoft.Json.Converters;
    using System.Runtime;
    using System.Runtime.Serialization;

    /// <summary>
    /// Defines values for JobScheduleState.
    /// </summary>
    [JsonConverter(typeof(StringEnumConverter))]
    public enum JobScheduleState
    {
        /// <summary>
        /// The Job Schedule is active and will create Jobs as per its
        /// schedule.
        /// </summary>
        [EnumMember(Value = "active")]
        Active,
        /// <summary>
        /// The Job Schedule has terminated, either by reaching its end time or
        /// by the user terminating it explicitly.
        /// </summary>
        [EnumMember(Value = "completed")]
        Completed,
        /// <summary>
        /// The user has disabled the Job Schedule. The scheduler will not
        /// initiate any new Jobs will on this schedule, but any existing
        /// active Job will continue to run.
        /// </summary>
        [EnumMember(Value = "disabled")]
        Disabled,
        /// <summary>
        /// The Job Schedule has no more work to do, or has been explicitly
        /// terminated by the user, but the termination operation is still in
        /// progress. The scheduler will not initiate any new Jobs for this Job
        /// Schedule, nor is any existing Job active.
        /// </summary>
        [EnumMember(Value = "terminating")]
        Terminating,
        /// <summary>
        /// The user has requested that the Job Schedule be deleted, but the
        /// delete operation is still in progress. The scheduler will not
        /// initiate any new Jobs for this Job Schedule, and will delete any
        /// existing Jobs and Tasks under the Job Schedule, including any
        /// active Job. The Job Schedule will be deleted when all Jobs and
        /// Tasks under the Job Schedule have been deleted.
        /// </summary>
        [EnumMember(Value = "deleting")]
        Deleting
    }
    internal static class JobScheduleStateEnumExtension
    {
        internal static string ToSerializedValue(this JobScheduleState? value)
        {
            return value == null ? null : ((JobScheduleState)value).ToSerializedValue();
        }

        internal static string ToSerializedValue(this JobScheduleState value)
        {
            switch( value )
            {
                case JobScheduleState.Active:
                    return "active";
                case JobScheduleState.Completed:
                    return "completed";
                case JobScheduleState.Disabled:
                    return "disabled";
                case JobScheduleState.Terminating:
                    return "terminating";
                case JobScheduleState.Deleting:
                    return "deleting";
            }
            return null;
        }

        internal static JobScheduleState? ParseJobScheduleState(this string value)
        {
            switch( value )
            {
                case "active":
                    return JobScheduleState.Active;
                case "completed":
                    return JobScheduleState.Completed;
                case "disabled":
                    return JobScheduleState.Disabled;
                case "terminating":
                    return JobScheduleState.Terminating;
                case "deleting":
                    return JobScheduleState.Deleting;
            }
            return null;
        }
    }
}
