// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Specifies details of a Job Manager Task.
    /// </summary>
    /// <remarks>
    /// The Job Manager Task is automatically started when the Job is created.
    /// The Batch service tries to schedule the Job Manager Task before any
    /// other Tasks in the Job. When shrinking a Pool, the Batch service tries
    /// to preserve Nodes where Job Manager Tasks are running for as long as
    /// possible (that is, Compute Nodes running 'normal' Tasks are removed
    /// before Compute Nodes running Job Manager Tasks). When a Job Manager
    /// Task fails and needs to be restarted, the system tries to schedule it
    /// at the highest priority. If there are no idle Compute Nodes available,
    /// the system may terminate one of the running Tasks in the Pool and
    /// return it to the queue in order to make room for the Job Manager Task
    /// to restart. Note that a Job Manager Task in one Job does not have
    /// priority over Tasks in other Jobs. Across Jobs, only Job level
    /// priorities are observed. For example, if a Job Manager in a priority 0
    /// Job needs to be restarted, it will not displace Tasks of a priority 1
    /// Job. Batch will retry Tasks when a recovery operation is triggered on a
    /// Node. Examples of recovery operations include (but are not limited to)
    /// when an unhealthy Node is rebooted or a Compute Node disappeared due to
    /// host failure. Retries due to recovery operations are independent of and
    /// are not counted against the maxTaskRetryCount. Even if the
    /// maxTaskRetryCount is 0, an internal retry due to a recovery operation
    /// may occur. Because of this, all Tasks should be idempotent. This means
    /// Tasks need to tolerate being interrupted and restarted without causing
    /// any corruption or duplicate data. The best practice for long running
    /// Tasks is to use some form of checkpointing.
    /// </remarks>
    public partial class JobManagerTask
    {
        /// <summary>
        /// Initializes a new instance of the JobManagerTask class.
        /// </summary>
        public JobManagerTask()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the JobManagerTask class.
        /// </summary>
        /// <param name="id">A string that uniquely identifies the Job Manager
        /// Task within the Job.</param>
        /// <param name="commandLine">The command line of the Job Manager
        /// Task.</param>
        /// <param name="displayName">The display name of the Job Manager
        /// Task.</param>
        /// <param name="containerSettings">The settings for the container
        /// under which the Job Manager Task runs.</param>
        /// <param name="resourceFiles">A list of files that the Batch service
        /// will download to the Compute Node before running the command
        /// line.</param>
        /// <param name="outputFiles">A list of files that the Batch service
        /// will upload from the Compute Node after running the command
        /// line.</param>
        /// <param name="environmentSettings">A list of environment variable
        /// settings for the Job Manager Task.</param>
        /// <param name="constraints">Constraints that apply to the Job Manager
        /// Task.</param>
        /// <param name="requiredSlots">The number of scheduling slots that the
        /// Task requires to run.</param>
        /// <param name="killJobOnCompletion">Whether completion of the Job
        /// Manager Task signifies completion of the entire Job.</param>
        /// <param name="userIdentity">The user identity under which the Job
        /// Manager Task runs.</param>
        /// <param name="runExclusive">Whether the Job Manager Task requires
        /// exclusive use of the Compute Node where it runs.</param>
        /// <param name="applicationPackageReferences">A list of Application
        /// Packages that the Batch service will deploy to the Compute Node
        /// before running the command line.</param>
        /// <param name="authenticationTokenSettings">The settings for an
        /// authentication token that the Task can use to perform Batch service
        /// operations.</param>
        /// <param name="allowLowPriorityNode">Whether the Job Manager Task may
        /// run on a Spot/Low-priority Compute Node.</param>
        public JobManagerTask(string id, string commandLine, string displayName = default(string), TaskContainerSettings containerSettings = default(TaskContainerSettings), IList<ResourceFile> resourceFiles = default(IList<ResourceFile>), IList<OutputFile> outputFiles = default(IList<OutputFile>), IList<EnvironmentSetting> environmentSettings = default(IList<EnvironmentSetting>), TaskConstraints constraints = default(TaskConstraints), int? requiredSlots = default(int?), bool? killJobOnCompletion = default(bool?), UserIdentity userIdentity = default(UserIdentity), bool? runExclusive = default(bool?), IList<ApplicationPackageReference> applicationPackageReferences = default(IList<ApplicationPackageReference>), AuthenticationTokenSettings authenticationTokenSettings = default(AuthenticationTokenSettings), bool? allowLowPriorityNode = default(bool?))
        {
            Id = id;
            DisplayName = displayName;
            CommandLine = commandLine;
            ContainerSettings = containerSettings;
            ResourceFiles = resourceFiles;
            OutputFiles = outputFiles;
            EnvironmentSettings = environmentSettings;
            Constraints = constraints;
            RequiredSlots = requiredSlots;
            KillJobOnCompletion = killJobOnCompletion;
            UserIdentity = userIdentity;
            RunExclusive = runExclusive;
            ApplicationPackageReferences = applicationPackageReferences;
            AuthenticationTokenSettings = authenticationTokenSettings;
            AllowLowPriorityNode = allowLowPriorityNode;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets a string that uniquely identifies the Job Manager Task
        /// within the Job.
        /// </summary>
        /// <remarks>
        /// The ID can contain any combination of alphanumeric characters
        /// including hyphens and underscores and cannot contain more than 64
        /// characters.
        /// </remarks>
        [JsonProperty(PropertyName = "id")]
        public string Id { get; set; }

        /// <summary>
        /// Gets or sets the display name of the Job Manager Task.
        /// </summary>
        /// <remarks>
        /// It need not be unique and can contain any Unicode characters up to
        /// a maximum length of 1024.
        /// </remarks>
        [JsonProperty(PropertyName = "displayName")]
        public string DisplayName { get; set; }

        /// <summary>
        /// Gets or sets the command line of the Job Manager Task.
        /// </summary>
        /// <remarks>
        /// The command line does not run under a shell, and therefore cannot
        /// take advantage of shell features such as environment variable
        /// expansion. If you want to take advantage of such features, you
        /// should invoke the shell in the command line, for example using "cmd
        /// /c MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux. If the
        /// command line refers to file paths, it should use a relative path
        /// (relative to the Task working directory), or use the Batch provided
        /// environment variable
        /// (https://docs.microsoft.com/azure/batch/batch-compute-node-environment-variables).
        /// </remarks>
        [JsonProperty(PropertyName = "commandLine")]
        public string CommandLine { get; set; }

        /// <summary>
        /// Gets or sets the settings for the container under which the Job
        /// Manager Task runs.
        /// </summary>
        /// <remarks>
        /// If the Pool that will run this Task has containerConfiguration set,
        /// this must be set as well. If the Pool that will run this Task
        /// doesn't have containerConfiguration set, this must not be set. When
        /// this is specified, all directories recursively below the
        /// AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories on the
        /// node) are mapped into the container, all Task environment variables
        /// are mapped into the container, and the Task command line is
        /// executed in the container. Files produced in the container outside
        /// of AZ_BATCH_NODE_ROOT_DIR might not be reflected to the host disk,
        /// meaning that Batch file APIs will not be able to access those
        /// files.
        /// </remarks>
        [JsonProperty(PropertyName = "containerSettings")]
        public TaskContainerSettings ContainerSettings { get; set; }

        /// <summary>
        /// Gets or sets a list of files that the Batch service will download
        /// to the Compute Node before running the command line.
        /// </summary>
        /// <remarks>
        /// Files listed under this element are located in the Task's working
        /// directory. There is a maximum size for the list of resource files.
        /// When the max size is exceeded, the request will fail and the
        /// response error code will be RequestEntityTooLarge. If this occurs,
        /// the collection of ResourceFiles must be reduced in size. This can
        /// be achieved using .zip files, Application Packages, or Docker
        /// Containers.
        /// </remarks>
        [JsonProperty(PropertyName = "resourceFiles")]
        public IList<ResourceFile> ResourceFiles { get; set; }

        /// <summary>
        /// Gets or sets a list of files that the Batch service will upload
        /// from the Compute Node after running the command line.
        /// </summary>
        /// <remarks>
        /// For multi-instance Tasks, the files will only be uploaded from the
        /// Compute Node on which the primary Task is executed.
        /// </remarks>
        [JsonProperty(PropertyName = "outputFiles")]
        public IList<OutputFile> OutputFiles { get; set; }

        /// <summary>
        /// Gets or sets a list of environment variable settings for the Job
        /// Manager Task.
        /// </summary>
        [JsonProperty(PropertyName = "environmentSettings")]
        public IList<EnvironmentSetting> EnvironmentSettings { get; set; }

        /// <summary>
        /// Gets or sets constraints that apply to the Job Manager Task.
        /// </summary>
        [JsonProperty(PropertyName = "constraints")]
        public TaskConstraints Constraints { get; set; }

        /// <summary>
        /// Gets or sets the number of scheduling slots that the Task requires
        /// to run.
        /// </summary>
        /// <remarks>
        /// The default is 1. A Task can only be scheduled to run on a compute
        /// node if the node has enough free scheduling slots available. For
        /// multi-instance Tasks, this property is not supported and must not
        /// be specified.
        /// </remarks>
        [JsonProperty(PropertyName = "requiredSlots")]
        public int? RequiredSlots { get; set; }

        /// <summary>
        /// Gets or sets whether completion of the Job Manager Task signifies
        /// completion of the entire Job.
        /// </summary>
        /// <remarks>
        /// If true, when the Job Manager Task completes, the Batch service
        /// marks the Job as complete. If any Tasks are still running at this
        /// time (other than Job Release), those Tasks are terminated. If
        /// false, the completion of the Job Manager Task does not affect the
        /// Job status. In this case, you should either use the
        /// onAllTasksComplete attribute to terminate the Job, or have a client
        /// or user terminate the Job explicitly. An example of this is if the
        /// Job Manager creates a set of Tasks but then takes no further role
        /// in their execution. The default value is true. If you are using the
        /// onAllTasksComplete and onTaskFailure attributes to control Job
        /// lifetime, and using the Job Manager Task only to create the Tasks
        /// for the Job (not to monitor progress), then it is important to set
        /// killJobOnCompletion to false.
        /// </remarks>
        [JsonProperty(PropertyName = "killJobOnCompletion")]
        public bool? KillJobOnCompletion { get; set; }

        /// <summary>
        /// Gets or sets the user identity under which the Job Manager Task
        /// runs.
        /// </summary>
        /// <remarks>
        /// If omitted, the Task runs as a non-administrative user unique to
        /// the Task.
        /// </remarks>
        [JsonProperty(PropertyName = "userIdentity")]
        public UserIdentity UserIdentity { get; set; }

        /// <summary>
        /// Gets or sets whether the Job Manager Task requires exclusive use of
        /// the Compute Node where it runs.
        /// </summary>
        /// <remarks>
        /// If true, no other Tasks will run on the same Node for as long as
        /// the Job Manager is running. If false, other Tasks can run
        /// simultaneously with the Job Manager on a Compute Node. The Job
        /// Manager Task counts normally against the Compute Node's concurrent
        /// Task limit, so this is only relevant if the Compute Node allows
        /// multiple concurrent Tasks. The default value is true.
        /// </remarks>
        [JsonProperty(PropertyName = "runExclusive")]
        public bool? RunExclusive { get; set; }

        /// <summary>
        /// Gets or sets a list of Application Packages that the Batch service
        /// will deploy to the Compute Node before running the command line.
        /// </summary>
        /// <remarks>
        /// Application Packages are downloaded and deployed to a shared
        /// directory, not the Task working directory. Therefore, if a
        /// referenced Application Package is already on the Compute Node, and
        /// is up to date, then it is not re-downloaded; the existing copy on
        /// the Compute Node is used. If a referenced Application Package
        /// cannot be installed, for example because the package has been
        /// deleted or because download failed, the Task fails.
        /// </remarks>
        [JsonProperty(PropertyName = "applicationPackageReferences")]
        public IList<ApplicationPackageReference> ApplicationPackageReferences { get; set; }

        /// <summary>
        /// Gets or sets the settings for an authentication token that the Task
        /// can use to perform Batch service operations.
        /// </summary>
        /// <remarks>
        /// If this property is set, the Batch service provides the Task with
        /// an authentication token which can be used to authenticate Batch
        /// service operations without requiring an Account access key. The
        /// token is provided via the AZ_BATCH_AUTHENTICATION_TOKEN environment
        /// variable. The operations that the Task can carry out using the
        /// token depend on the settings. For example, a Task can request Job
        /// permissions in order to add other Tasks to the Job, or check the
        /// status of the Job or of other Tasks under the Job.
        /// </remarks>
        [JsonProperty(PropertyName = "authenticationTokenSettings")]
        public AuthenticationTokenSettings AuthenticationTokenSettings { get; set; }

        /// <summary>
        /// Gets or sets whether the Job Manager Task may run on a
        /// Spot/Low-priority Compute Node.
        /// </summary>
        /// <remarks>
        /// The default value is true.
        /// </remarks>
        [JsonProperty(PropertyName = "allowLowPriorityNode")]
        public bool? AllowLowPriorityNode { get; set; }

    }
}
