// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// The execution constraints for a Job.
    /// </summary>
    public partial class JobConstraints
    {
        /// <summary>
        /// Initializes a new instance of the JobConstraints class.
        /// </summary>
        public JobConstraints()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the JobConstraints class.
        /// </summary>
        /// <param name="maxWallClockTime">The maximum elapsed time that the
        /// Job may run, measured from the time the Job is created.</param>
        /// <param name="maxTaskRetryCount">The maximum number of times each
        /// Task may be retried. The Batch service retries a Task if its exit
        /// code is nonzero.</param>
        public JobConstraints(System.TimeSpan? maxWallClockTime = default(System.TimeSpan?), int? maxTaskRetryCount = default(int?))
        {
            MaxWallClockTime = maxWallClockTime;
            MaxTaskRetryCount = maxTaskRetryCount;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the maximum elapsed time that the Job may run,
        /// measured from the time the Job is created.
        /// </summary>
        /// <remarks>
        /// If the Job does not complete within the time limit, the Batch
        /// service terminates it and any Tasks that are still running. In this
        /// case, the termination reason will be MaxWallClockTimeExpiry. If
        /// this property is not specified, there is no time limit on how long
        /// the Job may run.
        /// </remarks>
        [JsonProperty(PropertyName = "maxWallClockTime")]
        public System.TimeSpan? MaxWallClockTime { get; set; }

        /// <summary>
        /// Gets or sets the maximum number of times each Task may be retried.
        /// The Batch service retries a Task if its exit code is nonzero.
        /// </summary>
        /// <remarks>
        /// Note that this value specifically controls the number of retries.
        /// The Batch service will try each Task once, and may then retry up to
        /// this limit. For example, if the maximum retry count is 3, Batch
        /// tries a Task up to 4 times (one initial try and 3 retries). If the
        /// maximum retry count is 0, the Batch service does not retry Tasks.
        /// If the maximum retry count is -1, the Batch service retries Tasks
        /// without limit. The default value is 0 (no retries).
        /// </remarks>
        [JsonProperty(PropertyName = "maxTaskRetryCount")]
        public int? MaxTaskRetryCount { get; set; }

    }
}
