// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// A inbound NAT Pool that can be used to address specific ports on
    /// Compute Nodes in a Batch Pool externally.
    /// </summary>
    public partial class InboundNATPool
    {
        /// <summary>
        /// Initializes a new instance of the InboundNATPool class.
        /// </summary>
        public InboundNATPool()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the InboundNATPool class.
        /// </summary>
        /// <param name="name">The name of the endpoint.</param>
        /// <param name="protocol">The protocol of the endpoint.</param>
        /// <param name="backendPort">The port number on the Compute
        /// Node.</param>
        /// <param name="frontendPortRangeStart">The first port number in the
        /// range of external ports that will be used to provide inbound access
        /// to the backendPort on individual Compute Nodes.</param>
        /// <param name="frontendPortRangeEnd">The last port number in the
        /// range of external ports that will be used to provide inbound access
        /// to the backendPort on individual Compute Nodes.</param>
        /// <param name="networkSecurityGroupRules">A list of network security
        /// group rules that will be applied to the endpoint.</param>
        public InboundNATPool(string name, InboundEndpointProtocol protocol, int backendPort, int frontendPortRangeStart, int frontendPortRangeEnd, IList<NetworkSecurityGroupRule> networkSecurityGroupRules = default(IList<NetworkSecurityGroupRule>))
        {
            Name = name;
            Protocol = protocol;
            BackendPort = backendPort;
            FrontendPortRangeStart = frontendPortRangeStart;
            FrontendPortRangeEnd = frontendPortRangeEnd;
            NetworkSecurityGroupRules = networkSecurityGroupRules;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the name of the endpoint.
        /// </summary>
        /// <remarks>
        /// The name must be unique within a Batch Pool, can contain letters,
        /// numbers, underscores, periods, and hyphens. Names must start with a
        /// letter or number, must end with a letter, number, or underscore,
        /// and cannot exceed 77 characters.  If any invalid values are
        /// provided the request fails with HTTP status code 400.
        /// </remarks>
        [JsonProperty(PropertyName = "name")]
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the protocol of the endpoint.
        /// </summary>
        /// <remarks>
        /// Possible values include: 'tcp', 'udp'
        /// </remarks>
        [JsonProperty(PropertyName = "protocol")]
        public InboundEndpointProtocol Protocol { get; set; }

        /// <summary>
        /// Gets or sets the port number on the Compute Node.
        /// </summary>
        /// <remarks>
        /// This must be unique within a Batch Pool. Acceptable values are
        /// between 1 and 65535 except for 22, 3389, 29876 and 29877 as these
        /// are reserved. If any reserved values are provided the request fails
        /// with HTTP status code 400.
        /// </remarks>
        [JsonProperty(PropertyName = "backendPort")]
        public int BackendPort { get; set; }

        /// <summary>
        /// Gets or sets the first port number in the range of external ports
        /// that will be used to provide inbound access to the backendPort on
        /// individual Compute Nodes.
        /// </summary>
        /// <remarks>
        /// Acceptable values range between 1 and 65534 except ports from 50000
        /// to 55000 which are reserved. All ranges within a Pool must be
        /// distinct and cannot overlap. Each range must contain at least 40
        /// ports. If any reserved or overlapping values are provided the
        /// request fails with HTTP status code 400.
        /// </remarks>
        [JsonProperty(PropertyName = "frontendPortRangeStart")]
        public int FrontendPortRangeStart { get; set; }

        /// <summary>
        /// Gets or sets the last port number in the range of external ports
        /// that will be used to provide inbound access to the backendPort on
        /// individual Compute Nodes.
        /// </summary>
        /// <remarks>
        /// Acceptable values range between 1 and 65534 except ports from 50000
        /// to 55000 which are reserved by the Batch service. All ranges within
        /// a Pool must be distinct and cannot overlap. Each range must contain
        /// at least 40 ports. If any reserved or overlapping values are
        /// provided the request fails with HTTP status code 400.
        /// </remarks>
        [JsonProperty(PropertyName = "frontendPortRangeEnd")]
        public int FrontendPortRangeEnd { get; set; }

        /// <summary>
        /// Gets or sets a list of network security group rules that will be
        /// applied to the endpoint.
        /// </summary>
        /// <remarks>
        /// The maximum number of rules that can be specified across all the
        /// endpoints on a Batch Pool is 25. If no network security group rules
        /// are specified, a default rule will be created to allow inbound
        /// access to the specified backendPort. If the maximum number of
        /// network security group rules is exceeded the request fails with
        /// HTTP status code 400.
        /// </remarks>
        [JsonProperty(PropertyName = "networkSecurityGroupRules")]
        public IList<NetworkSecurityGroupRule> NetworkSecurityGroupRules { get; set; }

    }
}
