// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// A reference to an Azure Virtual Machines Marketplace Image or a Azure
    /// Compute Gallery Image. To get the list of all Azure Marketplace Image
    /// references verified by Azure Batch, see the 'List Supported Images'
    /// operation.
    /// </summary>
    public partial class ImageReference
    {
        /// <summary>
        /// Initializes a new instance of the ImageReference class.
        /// </summary>
        public ImageReference()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the ImageReference class.
        /// </summary>
        /// <param name="publisher">The publisher of the Azure Virtual Machines
        /// Marketplace Image.</param>
        /// <param name="offer">The offer type of the Azure Virtual Machines
        /// Marketplace Image.</param>
        /// <param name="sku">The SKU of the Azure Virtual Machines Marketplace
        /// Image.</param>
        /// <param name="version">The version of the Azure Virtual Machines
        /// Marketplace Image.</param>
        /// <param name="virtualMachineImageId">The ARM resource identifier of
        /// the Azure Compute Gallery Image. Compute Nodes in the Pool will be
        /// created using this Image Id. This is of the form
        /// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}/versions/{VersionId}
        /// or
        /// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}
        /// for always defaulting to the latest image version.</param>
        /// <param name="exactVersion">The specific version of the platform
        /// image or marketplace image used to create the node. This read-only
        /// field differs from 'version' only if the value specified for
        /// 'version' when the pool was created was 'latest'.</param>
        /// <param name="sharedGalleryImageId">The shared gallery image unique
        /// identifier</param>
        /// <param name="communityGalleryImageId">The community gallery image
        /// unique identifier</param>
        public ImageReference(string publisher = default(string), string offer = default(string), string sku = default(string), string version = default(string), string virtualMachineImageId = default(string), string exactVersion = default(string), string sharedGalleryImageId = default(string), string communityGalleryImageId = default(string))
        {
            Publisher = publisher;
            Offer = offer;
            Sku = sku;
            Version = version;
            VirtualMachineImageId = virtualMachineImageId;
            ExactVersion = exactVersion;
            SharedGalleryImageId = sharedGalleryImageId;
            CommunityGalleryImageId = communityGalleryImageId;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the publisher of the Azure Virtual Machines
        /// Marketplace Image.
        /// </summary>
        /// <remarks>
        /// For example, Canonical or MicrosoftWindowsServer.
        /// </remarks>
        [JsonProperty(PropertyName = "publisher")]
        public string Publisher { get; set; }

        /// <summary>
        /// Gets or sets the offer type of the Azure Virtual Machines
        /// Marketplace Image.
        /// </summary>
        /// <remarks>
        /// For example, UbuntuServer or WindowsServer.
        /// </remarks>
        [JsonProperty(PropertyName = "offer")]
        public string Offer { get; set; }

        /// <summary>
        /// Gets or sets the SKU of the Azure Virtual Machines Marketplace
        /// Image.
        /// </summary>
        /// <remarks>
        /// For example, 18.04-LTS or 2019-Datacenter.
        /// </remarks>
        [JsonProperty(PropertyName = "sku")]
        public string Sku { get; set; }

        /// <summary>
        /// Gets or sets the version of the Azure Virtual Machines Marketplace
        /// Image.
        /// </summary>
        /// <remarks>
        /// A value of 'latest' can be specified to select the latest version
        /// of an Image. If omitted, the default is 'latest'.
        /// </remarks>
        [JsonProperty(PropertyName = "version")]
        public string Version { get; set; }

        /// <summary>
        /// Gets or sets the ARM resource identifier of the Azure Compute
        /// Gallery Image. Compute Nodes in the Pool will be created using this
        /// Image Id. This is of the form
        /// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}/versions/{VersionId}
        /// or
        /// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}
        /// for always defaulting to the latest image version.
        /// </summary>
        /// <remarks>
        /// This property is mutually exclusive with other ImageReference
        /// properties. The Azure Compute Gallery Image must have replicas in
        /// the same region and must be in the same subscription as the Azure
        /// Batch account. If the image version is not specified in the
        /// imageId, the latest version will be used. For information about the
        /// firewall settings for the Batch Compute Node agent to communicate
        /// with the Batch service see
        /// https://docs.microsoft.com/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
        /// </remarks>
        [JsonProperty(PropertyName = "virtualMachineImageId")]
        public string VirtualMachineImageId { get; set; }

        /// <summary>
        /// Gets the specific version of the platform image or marketplace
        /// image used to create the node. This read-only field differs from
        /// 'version' only if the value specified for 'version' when the pool
        /// was created was 'latest'.
        /// </summary>
        [JsonProperty(PropertyName = "exactVersion")]
        public string ExactVersion { get; private set; }

        /// <summary>
        /// Gets or sets the shared gallery image unique identifier
        /// </summary>
        /// <remarks>
        /// This property is mutually exclusive with other properties and can
        /// be fetched from shared gallery image GET call.
        /// </remarks>
        [JsonProperty(PropertyName = "sharedGalleryImageId")]
        public string SharedGalleryImageId { get; set; }

        /// <summary>
        /// Gets or sets the community gallery image unique identifier
        /// </summary>
        /// <remarks>
        /// This property is mutually exclusive with other properties and can
        /// be fetched from community gallery image GET call.
        /// </remarks>
        [JsonProperty(PropertyName = "communityGalleryImageId")]
        public string CommunityGalleryImageId { get; set; }

    }
}
