// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// A reference to the Azure Virtual Machines Marketplace Image and
    /// additional information about the Image.
    /// </summary>
    public partial class ImageInformation
    {
        /// <summary>
        /// Initializes a new instance of the ImageInformation class.
        /// </summary>
        public ImageInformation()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the ImageInformation class.
        /// </summary>
        /// <param name="nodeAgentSKUId">The ID of the Compute Node agent SKU
        /// which the Image supports.</param>
        /// <param name="imageReference">The reference to the Azure Virtual
        /// Machine's Marketplace Image.</param>
        /// <param name="osType">The type of operating system (e.g. Windows or
        /// Linux) of the Image.</param>
        /// <param name="verificationType">Whether the Azure Batch service
        /// actively verifies that the Image is compatible with the associated
        /// Compute Node agent SKU.</param>
        /// <param name="capabilities">The capabilities or features which the
        /// Image supports.</param>
        /// <param name="batchSupportEndOfLife">The time when the Azure Batch
        /// service will stop accepting create Pool requests for the
        /// Image.</param>
        public ImageInformation(string nodeAgentSKUId, ImageReference imageReference, OSType osType, VerificationType verificationType, IList<string> capabilities = default(IList<string>), System.DateTime? batchSupportEndOfLife = default(System.DateTime?))
        {
            NodeAgentSKUId = nodeAgentSKUId;
            ImageReference = imageReference;
            OsType = osType;
            Capabilities = capabilities;
            BatchSupportEndOfLife = batchSupportEndOfLife;
            VerificationType = verificationType;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the ID of the Compute Node agent SKU which the Image
        /// supports.
        /// </summary>
        [JsonProperty(PropertyName = "nodeAgentSKUId")]
        public string NodeAgentSKUId { get; set; }

        /// <summary>
        /// Gets or sets the reference to the Azure Virtual Machine's
        /// Marketplace Image.
        /// </summary>
        [JsonProperty(PropertyName = "imageReference")]
        public ImageReference ImageReference { get; set; }

        /// <summary>
        /// Gets or sets the type of operating system (e.g. Windows or Linux)
        /// of the Image.
        /// </summary>
        /// <remarks>
        /// Possible values include: 'linux', 'windows'
        /// </remarks>
        [JsonProperty(PropertyName = "osType")]
        public OSType OsType { get; set; }

        /// <summary>
        /// Gets or sets the capabilities or features which the Image supports.
        /// </summary>
        /// <remarks>
        /// Not every capability of the Image is listed. Capabilities in this
        /// list are considered of special interest and are generally related
        /// to integration with other features in the Azure Batch service.
        /// </remarks>
        [JsonProperty(PropertyName = "capabilities")]
        public IList<string> Capabilities { get; set; }

        /// <summary>
        /// Gets or sets the time when the Azure Batch service will stop
        /// accepting create Pool requests for the Image.
        /// </summary>
        [JsonProperty(PropertyName = "batchSupportEndOfLife")]
        public System.DateTime? BatchSupportEndOfLife { get; set; }

        /// <summary>
        /// Gets or sets whether the Azure Batch service actively verifies that
        /// the Image is compatible with the associated Compute Node agent SKU.
        /// </summary>
        /// <remarks>
        /// Possible values include: 'verified', 'unverified'
        /// </remarks>
        [JsonProperty(PropertyName = "verificationType")]
        public VerificationType VerificationType { get; set; }

    }
}
