// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// Specifies how the Batch service responds to a particular exit
    /// condition.
    /// </summary>
    public partial class ExitOptions
    {
        /// <summary>
        /// Initializes a new instance of the ExitOptions class.
        /// </summary>
        public ExitOptions()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the ExitOptions class.
        /// </summary>
        /// <param name="jobAction">An action to take on the Job containing the
        /// Task, if the Task completes with the given exit condition and the
        /// Job's onTaskFailed property is
        /// 'performExitOptionsJobAction'.</param>
        /// <param name="dependencyAction">An action that the Batch service
        /// performs on Tasks that depend on this Task.</param>
        public ExitOptions(JobAction? jobAction = default(JobAction?), DependencyAction? dependencyAction = default(DependencyAction?))
        {
            JobAction = jobAction;
            DependencyAction = dependencyAction;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets an action to take on the Job containing the Task, if
        /// the Task completes with the given exit condition and the Job's
        /// onTaskFailed property is 'performExitOptionsJobAction'.
        /// </summary>
        /// <remarks>
        /// The default is none for exit code 0 and terminate for all other
        /// exit conditions. If the Job's onTaskFailed property is noaction,
        /// then specifying this property returns an error and the add Task
        /// request fails with an invalid property value error; if you are
        /// calling the REST API directly, the HTTP status code is 400 (Bad
        /// Request). Possible values include: 'none', 'disable', 'terminate'
        /// </remarks>
        [JsonProperty(PropertyName = "jobAction")]
        public JobAction? JobAction { get; set; }

        /// <summary>
        /// Gets or sets an action that the Batch service performs on Tasks
        /// that depend on this Task.
        /// </summary>
        /// <remarks>
        /// Possible values are 'satisfy' (allowing dependent tasks to
        /// progress) and 'block' (dependent tasks continue to wait). Batch
        /// does not yet support cancellation of dependent tasks. Possible
        /// values include: 'satisfy', 'block'
        /// </remarks>
        [JsonProperty(PropertyName = "dependencyAction")]
        public DependencyAction? DependencyAction { get; set; }

    }
}
