// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// A range of exit codes and how the Batch service should respond to exit
    /// codes within that range.
    /// </summary>
    public partial class ExitCodeRangeMapping
    {
        /// <summary>
        /// Initializes a new instance of the ExitCodeRangeMapping class.
        /// </summary>
        public ExitCodeRangeMapping()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the ExitCodeRangeMapping class.
        /// </summary>
        /// <param name="start">The first exit code in the range.</param>
        /// <param name="end">The last exit code in the range.</param>
        /// <param name="exitOptions">How the Batch service should respond if
        /// the Task exits with an exit code in the range start to end
        /// (inclusive).</param>
        public ExitCodeRangeMapping(int start, int end, ExitOptions exitOptions)
        {
            Start = start;
            End = end;
            ExitOptions = exitOptions;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the first exit code in the range.
        /// </summary>
        [JsonProperty(PropertyName = "start")]
        public int Start { get; set; }

        /// <summary>
        /// Gets or sets the last exit code in the range.
        /// </summary>
        [JsonProperty(PropertyName = "end")]
        public int End { get; set; }

        /// <summary>
        /// Gets or sets how the Batch service should respond if the Task exits
        /// with an exit code in the range start to end (inclusive).
        /// </summary>
        [JsonProperty(PropertyName = "exitOptions")]
        public ExitOptions ExitOptions { get; set; }

    }
}
