// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using Newtonsoft.Json.Converters;
    using System.Runtime;
    using System.Runtime.Serialization;

    /// <summary>
    /// Defines values for ElevationLevel.
    /// </summary>
    [JsonConverter(typeof(StringEnumConverter))]
    public enum ElevationLevel
    {
        /// <summary>
        /// The user is a standard user without elevated access.
        /// </summary>
        [EnumMember(Value = "nonadmin")]
        NonAdmin,
        /// <summary>
        /// The user is a user with elevated access and operates with full
        /// Administrator permissions.
        /// </summary>
        [EnumMember(Value = "admin")]
        Admin
    }
    internal static class ElevationLevelEnumExtension
    {
        internal static string ToSerializedValue(this ElevationLevel? value)
        {
            return value == null ? null : ((ElevationLevel)value).ToSerializedValue();
        }

        internal static string ToSerializedValue(this ElevationLevel value)
        {
            switch( value )
            {
                case ElevationLevel.NonAdmin:
                    return "nonadmin";
                case ElevationLevel.Admin:
                    return "admin";
            }
            return null;
        }

        internal static ElevationLevel? ParseElevationLevel(this string value)
        {
            switch( value )
            {
                case "nonadmin":
                    return ElevationLevel.NonAdmin;
                case "admin":
                    return ElevationLevel.Admin;
            }
            return null;
        }
    }
}
