// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using Newtonsoft.Json.Converters;
    using System.Runtime;
    using System.Runtime.Serialization;

    /// <summary>
    /// Defines values for DiskEncryptionTarget.
    /// </summary>
    [JsonConverter(typeof(StringEnumConverter))]
    public enum DiskEncryptionTarget
    {
        /// <summary>
        /// The OS Disk on the compute node is encrypted.
        /// </summary>
        [EnumMember(Value = "osdisk")]
        OsDisk,
        /// <summary>
        /// The temporary disk on the compute node is encrypted. On Linux this
        /// encryption applies to other partitions (such as those on mounted
        /// data disks) when encryption occurs at boot time.
        /// </summary>
        [EnumMember(Value = "temporarydisk")]
        TemporaryDisk
    }
    internal static class DiskEncryptionTargetEnumExtension
    {
        internal static string ToSerializedValue(this DiskEncryptionTarget? value)
        {
            return value == null ? null : ((DiskEncryptionTarget)value).ToSerializedValue();
        }

        internal static string ToSerializedValue(this DiskEncryptionTarget value)
        {
            switch( value )
            {
                case DiskEncryptionTarget.OsDisk:
                    return "osdisk";
                case DiskEncryptionTarget.TemporaryDisk:
                    return "temporarydisk";
            }
            return null;
        }

        internal static DiskEncryptionTarget? ParseDiskEncryptionTarget(this string value)
        {
            switch( value )
            {
                case "osdisk":
                    return DiskEncryptionTarget.OsDisk;
                case "temporarydisk":
                    return DiskEncryptionTarget.TemporaryDisk;
            }
            return null;
        }
    }
}
