// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// Settings which will be used by the data disks associated to Compute
    /// Nodes in the Pool. When using attached data disks, you need to mount
    /// and format the disks from within a VM to use them.
    /// </summary>
    public partial class DataDisk
    {
        /// <summary>
        /// Initializes a new instance of the DataDisk class.
        /// </summary>
        public DataDisk()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the DataDisk class.
        /// </summary>
        /// <param name="lun">The logical unit number.</param>
        /// <param name="diskSizeGB">The initial disk size in
        /// gigabytes.</param>
        /// <param name="caching">The type of caching to be enabled for the
        /// data disks.</param>
        /// <param name="storageAccountType">The storage Account type to be
        /// used for the data disk.</param>
        public DataDisk(int lun, int diskSizeGB, CachingType? caching = default(CachingType?), StorageAccountType? storageAccountType = default(StorageAccountType?))
        {
            Lun = lun;
            Caching = caching;
            DiskSizeGB = diskSizeGB;
            StorageAccountType = storageAccountType;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the logical unit number.
        /// </summary>
        /// <remarks>
        /// The lun is used to uniquely identify each data disk. If attaching
        /// multiple disks, each should have a distinct lun. The value must be
        /// between 0 and 63, inclusive.
        /// </remarks>
        [JsonProperty(PropertyName = "lun")]
        public int Lun { get; set; }

        /// <summary>
        /// Gets or sets the type of caching to be enabled for the data disks.
        /// </summary>
        /// <remarks>
        /// The default value for caching is readwrite. For information about
        /// the caching options see:
        /// https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/.
        /// Possible values include: 'none', 'readOnly', 'readWrite'
        /// </remarks>
        [JsonProperty(PropertyName = "caching")]
        public CachingType? Caching { get; set; }

        /// <summary>
        /// Gets or sets the initial disk size in gigabytes.
        /// </summary>
        [JsonProperty(PropertyName = "diskSizeGB")]
        public int DiskSizeGB { get; set; }

        /// <summary>
        /// Gets or sets the storage Account type to be used for the data disk.
        /// </summary>
        /// <remarks>
        /// If omitted, the default is "standard_lrs". Possible values include:
        /// 'StandardLRS', 'PremiumLRS', 'StandardSSDLRS'
        /// </remarks>
        [JsonProperty(PropertyName = "storageAccountType")]
        public StorageAccountType? StorageAccountType { get; set; }

    }
}
