// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using Newtonsoft.Json.Converters;
    using System.Runtime;
    using System.Runtime.Serialization;

    /// <summary>
    /// Defines values for ContainerWorkingDirectory.
    /// </summary>
    [JsonConverter(typeof(StringEnumConverter))]
    public enum ContainerWorkingDirectory
    {
        /// <summary>
        /// Use the standard Batch service Task working directory, which will
        /// contain the Task Resource Files populated by Batch.
        /// </summary>
        [EnumMember(Value = "taskWorkingDirectory")]
        TaskWorkingDirectory,
        /// <summary>
        /// Use the working directory defined in the container Image. Beware
        /// that this directory will not contain the Resource Files downloaded
        /// by Batch.
        /// </summary>
        [EnumMember(Value = "containerImageDefault")]
        ContainerImageDefault
    }
    internal static class ContainerWorkingDirectoryEnumExtension
    {
        internal static string ToSerializedValue(this ContainerWorkingDirectory? value)
        {
            return value == null ? null : ((ContainerWorkingDirectory)value).ToSerializedValue();
        }

        internal static string ToSerializedValue(this ContainerWorkingDirectory value)
        {
            switch( value )
            {
                case ContainerWorkingDirectory.TaskWorkingDirectory:
                    return "taskWorkingDirectory";
                case ContainerWorkingDirectory.ContainerImageDefault:
                    return "containerImageDefault";
            }
            return null;
        }

        internal static ContainerWorkingDirectory? ParseContainerWorkingDirectory(this string value)
        {
            switch( value )
            {
                case "taskWorkingDirectory":
                    return ContainerWorkingDirectory.TaskWorkingDirectory;
                case "containerImageDefault":
                    return ContainerWorkingDirectory.ContainerImageDefault;
            }
            return null;
        }
    }
}
