// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// A user Account for RDP or SSH access on a Compute Node.
    /// </summary>
    public partial class ComputeNodeUser
    {
        /// <summary>
        /// Initializes a new instance of the ComputeNodeUser class.
        /// </summary>
        public ComputeNodeUser()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the ComputeNodeUser class.
        /// </summary>
        /// <param name="name">The user name of the Account.</param>
        /// <param name="isAdmin">Whether the Account should be an
        /// administrator on the Compute Node.</param>
        /// <param name="expiryTime">The time at which the Account should
        /// expire.</param>
        /// <param name="password">The password of the Account.</param>
        /// <param name="sshPublicKey">The SSH public key that can be used for
        /// remote login to the Compute Node.</param>
        public ComputeNodeUser(string name, bool? isAdmin = default(bool?), System.DateTime? expiryTime = default(System.DateTime?), string password = default(string), string sshPublicKey = default(string))
        {
            Name = name;
            IsAdmin = isAdmin;
            ExpiryTime = expiryTime;
            Password = password;
            SshPublicKey = sshPublicKey;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the user name of the Account.
        /// </summary>
        [JsonProperty(PropertyName = "name")]
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets whether the Account should be an administrator on the
        /// Compute Node.
        /// </summary>
        /// <remarks>
        /// The default value is false.
        /// </remarks>
        [JsonProperty(PropertyName = "isAdmin")]
        public bool? IsAdmin { get; set; }

        /// <summary>
        /// Gets or sets the time at which the Account should expire.
        /// </summary>
        /// <remarks>
        /// If omitted, the default is 1 day from the current time. For Linux
        /// Compute Nodes, the expiryTime has a precision up to a day.
        /// </remarks>
        [JsonProperty(PropertyName = "expiryTime")]
        public System.DateTime? ExpiryTime { get; set; }

        /// <summary>
        /// Gets or sets the password of the Account.
        /// </summary>
        /// <remarks>
        /// The password is required for Windows Compute Nodes. For Linux
        /// Compute Nodes, the password can optionally be specified along with
        /// the sshPublicKey property.
        /// </remarks>
        [JsonProperty(PropertyName = "password")]
        public string Password { get; set; }

        /// <summary>
        /// Gets or sets the SSH public key that can be used for remote login
        /// to the Compute Node.
        /// </summary>
        /// <remarks>
        /// The public key should be compatible with OpenSSH encoding and
        /// should be base 64 encoded. This property can be specified only for
        /// Linux Compute Nodes. If this is specified for a Windows Compute
        /// Node, then the Batch service rejects the request; if you are
        /// calling the REST API directly, the HTTP status code is 400 (Bad
        /// Request).
        /// </remarks>
        [JsonProperty(PropertyName = "sshPublicKey")]
        public string SshPublicKey { get; set; }

    }
}
