// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using Newtonsoft.Json.Converters;
    using System.Runtime;
    using System.Runtime.Serialization;

    /// <summary>
    /// Defines values for ComputeNodeRebootOption.
    /// </summary>
    [JsonConverter(typeof(StringEnumConverter))]
    public enum ComputeNodeRebootOption
    {
        /// <summary>
        /// Terminate running Task processes and requeue the Tasks. The Tasks
        /// will run again when a Compute Node is available. Restart the
        /// Compute Node as soon as Tasks have been terminated.
        /// </summary>
        [EnumMember(Value = "requeue")]
        Requeue,
        /// <summary>
        /// Terminate running Tasks. The Tasks will be completed with
        /// failureInfo indicating that they were terminated, and will not run
        /// again. Restart the Compute Node as soon as Tasks have been
        /// terminated.
        /// </summary>
        [EnumMember(Value = "terminate")]
        Terminate,
        /// <summary>
        /// Allow currently running Tasks to complete. Schedule no new Tasks
        /// while waiting. Restart the Compute Node when all Tasks have
        /// completed.
        /// </summary>
        [EnumMember(Value = "taskcompletion")]
        TaskCompletion,
        /// <summary>
        /// Allow currently running Tasks to complete, then wait for all Task
        /// data retention periods to expire. Schedule no new Tasks while
        /// waiting. Restart the Compute Node when all Task retention periods
        /// have expired.
        /// </summary>
        [EnumMember(Value = "retaineddata")]
        RetainedData
    }
    internal static class ComputeNodeRebootOptionEnumExtension
    {
        internal static string ToSerializedValue(this ComputeNodeRebootOption? value)
        {
            return value == null ? null : ((ComputeNodeRebootOption)value).ToSerializedValue();
        }

        internal static string ToSerializedValue(this ComputeNodeRebootOption value)
        {
            switch( value )
            {
                case ComputeNodeRebootOption.Requeue:
                    return "requeue";
                case ComputeNodeRebootOption.Terminate:
                    return "terminate";
                case ComputeNodeRebootOption.TaskCompletion:
                    return "taskcompletion";
                case ComputeNodeRebootOption.RetainedData:
                    return "retaineddata";
            }
            return null;
        }

        internal static ComputeNodeRebootOption? ParseComputeNodeRebootOption(this string value)
        {
            switch( value )
            {
                case "requeue":
                    return ComputeNodeRebootOption.Requeue;
                case "terminate":
                    return ComputeNodeRebootOption.Terminate;
                case "taskcompletion":
                    return ComputeNodeRebootOption.TaskCompletion;
                case "retaineddata":
                    return ComputeNodeRebootOption.RetainedData;
            }
            return null;
        }
    }
}
