// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// Information about the Compute Node on which a Task ran.
    /// </summary>
    public partial class ComputeNodeInformation
    {
        /// <summary>
        /// Initializes a new instance of the ComputeNodeInformation class.
        /// </summary>
        public ComputeNodeInformation()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the ComputeNodeInformation class.
        /// </summary>
        /// <param name="affinityId">An identifier for the Node on which the
        /// Task ran, which can be passed when adding a Task to request that
        /// the Task be scheduled on this Compute Node.</param>
        /// <param name="nodeUrl">The URL of the Compute Node on which the Task
        /// ran. </param>
        /// <param name="poolId">The ID of the Pool on which the Task
        /// ran.</param>
        /// <param name="nodeId">The ID of the Compute Node on which the Task
        /// ran.</param>
        /// <param name="taskRootDirectory">The root directory of the Task on
        /// the Compute Node.</param>
        /// <param name="taskRootDirectoryUrl">The URL to the root directory of
        /// the Task on the Compute Node.</param>
        public ComputeNodeInformation(string affinityId = default(string), string nodeUrl = default(string), string poolId = default(string), string nodeId = default(string), string taskRootDirectory = default(string), string taskRootDirectoryUrl = default(string))
        {
            AffinityId = affinityId;
            NodeUrl = nodeUrl;
            PoolId = poolId;
            NodeId = nodeId;
            TaskRootDirectory = taskRootDirectory;
            TaskRootDirectoryUrl = taskRootDirectoryUrl;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets an identifier for the Node on which the Task ran,
        /// which can be passed when adding a Task to request that the Task be
        /// scheduled on this Compute Node.
        /// </summary>
        [JsonProperty(PropertyName = "affinityId")]
        public string AffinityId { get; set; }

        /// <summary>
        /// Gets or sets the URL of the Compute Node on which the Task ran.
        /// </summary>
        [JsonProperty(PropertyName = "nodeUrl")]
        public string NodeUrl { get; set; }

        /// <summary>
        /// Gets or sets the ID of the Pool on which the Task ran.
        /// </summary>
        [JsonProperty(PropertyName = "poolId")]
        public string PoolId { get; set; }

        /// <summary>
        /// Gets or sets the ID of the Compute Node on which the Task ran.
        /// </summary>
        [JsonProperty(PropertyName = "nodeId")]
        public string NodeId { get; set; }

        /// <summary>
        /// Gets or sets the root directory of the Task on the Compute Node.
        /// </summary>
        [JsonProperty(PropertyName = "taskRootDirectory")]
        public string TaskRootDirectory { get; set; }

        /// <summary>
        /// Gets or sets the URL to the root directory of the Task on the
        /// Compute Node.
        /// </summary>
        [JsonProperty(PropertyName = "taskRootDirectoryUrl")]
        public string TaskRootDirectoryUrl { get; set; }

    }
}
