// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// An error encountered by a Compute Node.
    /// </summary>
    public partial class ComputeNodeError
    {
        /// <summary>
        /// Initializes a new instance of the ComputeNodeError class.
        /// </summary>
        public ComputeNodeError()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the ComputeNodeError class.
        /// </summary>
        /// <param name="code">An identifier for the Compute Node error. Codes
        /// are invariant and are intended to be consumed
        /// programmatically.</param>
        /// <param name="message">A message describing the Compute Node error,
        /// intended to be suitable for display in a user interface.</param>
        /// <param name="errorDetails">The list of additional error details
        /// related to the Compute Node error.</param>
        public ComputeNodeError(string code = default(string), string message = default(string), IList<NameValuePair> errorDetails = default(IList<NameValuePair>))
        {
            Code = code;
            Message = message;
            ErrorDetails = errorDetails;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets an identifier for the Compute Node error. Codes are
        /// invariant and are intended to be consumed programmatically.
        /// </summary>
        [JsonProperty(PropertyName = "code")]
        public string Code { get; set; }

        /// <summary>
        /// Gets or sets a message describing the Compute Node error, intended
        /// to be suitable for display in a user interface.
        /// </summary>
        [JsonProperty(PropertyName = "message")]
        public string Message { get; set; }

        /// <summary>
        /// Gets or sets the list of additional error details related to the
        /// Compute Node error.
        /// </summary>
        [JsonProperty(PropertyName = "errorDetails")]
        public IList<NameValuePair> ErrorDetails { get; set; }

    }
}
