// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using Newtonsoft.Json.Converters;
    using System.Runtime;
    using System.Runtime.Serialization;

    /// <summary>
    /// Defines values for ComputeNodeDeallocationOption.
    /// </summary>
    [JsonConverter(typeof(StringEnumConverter))]
    public enum ComputeNodeDeallocationOption
    {
        /// <summary>
        /// Terminate running Task processes and requeue the Tasks. The Tasks
        /// will run again when a Compute Node is available. Remove Compute
        /// Nodes as soon as Tasks have been terminated.
        /// </summary>
        [EnumMember(Value = "requeue")]
        Requeue,
        /// <summary>
        /// Terminate running Tasks. The Tasks will be completed with
        /// failureInfo indicating that they were terminated, and will not run
        /// again. Remove Compute Nodes as soon as Tasks have been terminated.
        /// </summary>
        [EnumMember(Value = "terminate")]
        Terminate,
        /// <summary>
        /// Allow currently running Tasks to complete. Schedule no new Tasks
        /// while waiting. Remove Compute Nodes when all Tasks have completed.
        /// </summary>
        [EnumMember(Value = "taskcompletion")]
        TaskCompletion,
        /// <summary>
        /// Allow currently running Tasks to complete, then wait for all Task
        /// data retention periods to expire. Schedule no new Tasks while
        /// waiting. Remove Compute Nodes when all Task retention periods have
        /// expired.
        /// </summary>
        [EnumMember(Value = "retaineddata")]
        RetainedData
    }
    internal static class ComputeNodeDeallocationOptionEnumExtension
    {
        internal static string ToSerializedValue(this ComputeNodeDeallocationOption? value)
        {
            return value == null ? null : ((ComputeNodeDeallocationOption)value).ToSerializedValue();
        }

        internal static string ToSerializedValue(this ComputeNodeDeallocationOption value)
        {
            switch( value )
            {
                case ComputeNodeDeallocationOption.Requeue:
                    return "requeue";
                case ComputeNodeDeallocationOption.Terminate:
                    return "terminate";
                case ComputeNodeDeallocationOption.TaskCompletion:
                    return "taskcompletion";
                case ComputeNodeDeallocationOption.RetainedData:
                    return "retaineddata";
            }
            return null;
        }

        internal static ComputeNodeDeallocationOption? ParseComputeNodeDeallocationOption(this string value)
        {
            switch( value )
            {
                case "requeue":
                    return ComputeNodeDeallocationOption.Requeue;
                case "terminate":
                    return ComputeNodeDeallocationOption.Terminate;
                case "taskcompletion":
                    return ComputeNodeDeallocationOption.TaskCompletion;
                case "retaineddata":
                    return ComputeNodeDeallocationOption.RetainedData;
            }
            return null;
        }
    }
}
